<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;

use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Plan;
use Illuminate\Http\Request;
use App\Models\Course;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\File;
use Barryvdh\DomPDF\Facade\Pdf as PDF;

class PlanController extends Controller
{
    //
    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $tipoacceso = 1;                //si el usuario esta autentificado es admin le pasamos la lista del sidebar
                return view('admin.planes_estudio.planes.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }



    public function store(Request $request)
    {
        $plan = new Plan();
        $plan->nombre = $request->input('txt-nombre');
        $plan->tipo = $request->input('txt-tipo');
        $plan->modalidad = $request->input('txt-modalidad');
        $plan->enfoque = $request->input('txt-enfoque');
        $plan->program_id = $request->input('txt-program_id');
        // Asigna otros campos según tus necesidades

        // Guarda el nuevo registro en la base de datos

        if ($plan->save()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'Plan guardado',
            ]);
        } else {
            // El guardado falló
            return response()->json([
                "status" => false,
                "mensaje" => 'Plan no guardado'
            ]);
        }
    }


    public function update(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'mimes:pdf,jpg,png|max:5000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.mimes' => 'El archivo debe ser un PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 5000 KB.',
        ]);

        // documento inválido
        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators',
                "mensaje" => $validator->errors(),
            ]);
        } else {
            $item = Plan::find($request->input('txt-id'));
            $item->nombre = $request->input('txt-nombre');
            $item->fecha = $request->input('txt-fecha');
            $item->documento = "--";
            // Asigna otros campos según tus necesidades

            // Guarda el nuevo registro en la base de datos
            $idplan = $request->input('txt-id');

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName =  'public/planes/' . $idplan . '/';
                Storage::disk('local')->makeDirectory($folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $archivo->storeAs($folderName, 'resolucion' . '.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = $folderName . '/' . 'resolucion' . '.pdf';  // ruta del archivo
                $item->documento = $filePath;
                // guardar Pago - documento
                if ($item->save()) {
                    return response()->json(["status" => true, "mensaje" => 'Plan actualizado']);
                }
            }

            // guardar
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Plan actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Plan no actualizado']);
            }
        }
    }


    public function list(Request $request)
    {
        if ($request->ajax()) {
            //
            $data = DB::table('planes as pl')
                    ->join('programas as p', 'pl.program_id', '=', 'p.id')
                    ->leftJoin('periodos as ci', 'ci.plan_id', '=', 'pl.id')
                    ->select(
                        'pl.id',
                        'pl.program_id',
                        'pl.nombre as nombreplan',
                        'pl.tipo',
                        'pl.modalidad',
                        'pl.enfoque',
                        'pl.documento',
                        'pl.fecha',
                        'p.nombre as nombreprograma',
                        'p.nivel_formativo as nivelformativo',
                        DB::raw('CASE WHEN COUNT(ci.id) > 0 THEN 1 ELSE 0 END AS estado_cursos')
                    )
                    ->groupBy(
                        'pl.id',
                        'pl.program_id',
                        'pl.nombre',
                        'pl.tipo',
                        'pl.modalidad',
                        'pl.enfoque',
                        'pl.documento',
                        'pl.fecha',
                        'p.nombre',
                        'p.nivel_formativo'
                    )
                    ->get();
            
            return \Yajra\DataTables\DataTables::of($data)->addIndexColumn()->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }



    public function destroy($id)
    {
        // Busca el registro por su ID
        $plan = Plan::find($id);
        
        // Verifica si el registro existe
        if (!$plan) {
            return response()->json([
                "status" => false,
                "mensaje" => 'El registro no existe'
            ]);
        }
        
        // Elimina el registro de la base de datos
        if ($plan->delete()) {
            return response()->json([
                "status" => true,
                "mensaje" => 'El registro fue eliminado'
            ]);
        } else {
            return response()->json([
                "status" => false,
                "mensaje" => 'No se puede eliminar porque ya cuenta con registros asociados'
            ]);
        }
    }



    public function ajax_all_with_programs(Request $request)
    {
        if ($request->ajax()) {
            // $data = Plan::all();
            $data = DB::table('planes AS pl')->join('programas AS pr', 'pl.program_id', '=', 'pr.id')
                ->select('pl.id', 'pl.nombre', 'pr.nombre AS nombreprograma', 'pl.tipo', 'pl.modalidad', 'pl.enfoque')
                ->orderBy('nombre', 'desc')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all_by_idprogram(Request $request, $idprogram)
    {
        if ($request->ajax()) {
            // $data = Plan::all();
            $data = Plan::where('program_id', $idprogram)
                ->orderBy('nombre', 'desc')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all_planes(Request $request)
    {
        if ($request->ajax()) {
            // $data = Plan::all();
            $data = Plan::all();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function ajax_all_planes_by_idprogram (Request $request, $idprogram) {
        if ($request->ajax()) {
            // $data = Plan::all();
            $data = Plan::all()->where("program_id", $idprogram);
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function ajax_all_by_idPLan_curses(Request $request, $idprogram)
    {
        if ($request->ajax()) {
            // $data = Plan::all();
            $curso = Course::select(
                'cursos.nombre as curso',
                'cursos.tipo as tipo',
                'cursos.creditos as creditos',
                'cursos.horas as horas',
                'periodos.numero as periodo',
                'modulos_formativos.numero as modulo'
            )
                ->join('modulos_formativos', 'modulos_formativos.id', '=', 'cursos.training_module_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')

                ->get();
            return response()->json($curso);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function list_by_idplan(Request $request)
    {
        $idplan = $request->input('id');
        if ($request->ajax()) {
            // query
            $curso = Course::select(
                'cursos.id',
                'cursos.id as idplan',
                'cursos.nombre as curso',
                'cursos.tipo',
                'cursos.creditos',
                'cursos.horas',
                'periodos.numero as periodo',
                'modulos_formativos.numero as modulo',
                'modulos_formativos.descripcion as descripcion'
            )
                ->join('modulos_formativos', 'modulos_formativos.id', '=', 'cursos.training_module_id')
                ->join('periodos', 'periodos.id', '=', 'cursos.period_id')
                ->join('planes', 'planes.id', '=', 'periodos.plan_id')
                ->where('planes.id', '=', $idplan)
                ->orderByRaw('periodo = 0')
                ->orderBy('periodo', 'asc')
                ->get();
            // datatable
            return DataTables::of($curso)
                ->addIndexColumn()
                ->make(true);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error: no se pueden cargar los archivos']);
    }

    public function verDocumentoPlan($idplan)
    {
        $item = Plan::find($idplan);

        $item->documento;

        if ($item->documento == "--" || $item->documento == "") {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
        }

        $file = storage_path('app/') . $item->documento;

        if (file_exists($file)) {
            return $this->funcion_verArchivo($file);
        } else {
            $file = storage_path('app/public/sinImagen.jpg');
            return $this->funcion_verArchivo($file);
            // abort(404, 'Archivo no encontrado!');
        }
    }

    public function funcion_verArchivo($file)
    {
        $extension = pathinfo($file, PATHINFO_EXTENSION);

        // Verificar la extensión y establecer el tipo de contenido correspondiente
        switch ($extension) {
            case 'pdf':
                $contentType = 'application/pdf';
                break;
            case 'png':
                $contentType = 'image/png';
                break;
            case 'jpg':
            case 'jpeg':
                $contentType = 'image/jpeg';
                break;
            default:
                abort(404, 'Formato de archivo no admitido.');
        }

        $headers = [
            'Content-Type' => $contentType,
        ];

        $fileTitle = 'documento.' . $extension;
        return response()->download($file, $fileTitle, $headers, 'inline');
    }
}
