<?php

namespace App\Http\Controllers\admin;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Teacher;
use App\Models\User;
use Carbon\Carbon;
use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Yajra\DataTables\Facades\DataTables;

class TeacherController extends Controller
{


    public function index(Request $request)
    {
        $objeto = new SidebarController();

        $sidebar = $objeto->ListmodulosSidebar();

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');

            $idusertype = Auth::User()->usertype_id;

            if ($userTypeAccesocombo == "1" && ($idusertype == "1" || $idusertype == "4" || $idusertype == "5" || $idusertype == "7")) {
                $tipoacceso = 1;
                return view('admin.docentes.gestionar.index')->with('datatipoacceso', $tipoacceso)->with('datalist', $sidebar);
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.student.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }

    public function list(Request $request)
    {
        if ($request->ajax()) {
            // query
            $data = Teacher::join('usuarios AS u', 'u.id', '=', 'docentes.user_id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->join('tipos_contratos_docentes AS tct', 'tct.id', '=', 'docentes.teachercontracttype_id')
                ->join('tipos_usuarios AS ut', 'ut.id', '=', 'u.usertype_id')
                ->join('ubigeos AS ub', 'ub.id', '=', 'u.ubigeo_id')
                ->join('generos AS g', 'g.id', '=', 'u.genre_id')
                ->get([
                    'docentes.id AS iddocente',
                    'tct.id AS idteachercontracttype',
                    'tct.tipo AS tipocontrato',
                    'docentes.horas_lectivas',
                    'docentes.horas_nolectivas',
                    'docentes.estado',
                    'docentes.teachertype_id AS teachertype',
                    'u.id AS iduser',
                    'it.id AS ididentificationtype', 'it.tipo AS tipoidenti',
                    'u.nroidenti',
                    'u.password',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    DB::raw('CONCAT(u.apellido_pa, " ", u.apellido_ma) AS apellidos'),
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado AS acceso',
                    'ut.id AS idusertype',
                    'ut.tipo',
                    'ub.id AS idubigeo',
                    DB::raw('SUBSTRING(ub.id, 1, 2) AS iddepartamento'),
                    'ub.departamento',
                    DB::raw('SUBSTRING(ub.id, 3, 2) AS idprovincia'),
                    'ub.provincia',
                    DB::raw('SUBSTRING(ub.id, 5, 2) AS iddistrito'),
                    'ub.distrito',
                    'g.id AS idgenre',
                    'g.nombre AS nombregenre'
                ]);
            // datatable
            return DataTables::of($data)
                ->addIndexColumn()
                ->make(true);
        }

        return  response()->json([
            "status" => false,
            "mensaje" => 'Error: no se pueden cargar los archivos'
        ]);
    }

    public function store(Request $request)
    {

        $r_nroidenti = $request->input('txt_nroidenti');

        $usuario = User::where('nroidenti', $r_nroidenti)->first();

        if ($usuario) {
            $docente = Teacher::where('user_id', $usuario->id)->first();
        }

        // VALIDAR SI EXISTE UN DOCENTE CON ESE NUMERO DE IDENTIFICACION
        if ($usuario && $docente) {
            return response()->json(["status" => false, "mensaje" => 'El docente ya está registrado']);
        }
        // SI NO EXISTE EL DOCENTE CON EL NUMERO DE IDENTIFICACION
        else {
            // SI EL USUARIO EXISTE
            if ($usuario) {
                // setear datos
                if ($usuario->usertype_id == '1') {
                    $new_usertype_id = 4;
                } else if ($usuario->usertype_id == '3') {
                    $new_usertype_id = 6;
                } else if ($usuario->usertype_id == '5') {
                    $new_usertype_id = 7;
                }
                $usuario->usertype_id = $new_usertype_id;
                $usuario->password = $request->input('txt_password');
                $usuario->estado = $request->input('txt_acceso');
                $usuario->nombres = ucwords(strtolower($request->input('txt_nombres')));
                $usuario->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
                $usuario->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
                $usuario->fecnac = $request->input('txt_fecnac');
                $usuario->correo = $request->input('txt_correo');
                $usuario->telefono = $request->input('txt_telefono');
                $usuario->celular = $request->input('txt_celular');
                $usuario->genre_id = $request->input('txt_genre_id');
                $usuario->direccion = $request->input('txt_direccion');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $usuario->ubigeo_id = $idubigeo;
                // validar guardado
                if ($usuario->save()) {
                    // recoger id insertado
                    $userId = $usuario->id;
                    // nuevo objeto
                    $item2 = new Teacher();
                    $item2->teachercontracttype_id = $request->input('txt_tipocontrato');
                    $item2->estado = $request->input('txt_estado');
                    $item2->teachertype_id = $request->input('txt-teachertypes');
                    $item2->user_id = $userId;

                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }

            // SI EL USUARIO NO EXISTE
            else {
                // nuevo objeto
                $item = new User();
                // setear datos
                $item->identificationtype_id = $request->input('txt-identificationtype');
                $item->nroidenti = $request->input('txt_nroidenti');
                $item->password = $request->input('txt_password');
                $item->estado = $request->input('txt_acceso');
                $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
                $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
                $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
                $item->fecnac = $request->input('txt_fecnac');
                $item->correo = $request->input('txt_correo');
                $item->telefono = $request->input('txt_telefono');
                $item->celular = $request->input('txt_celular');
                $item->genre_id = $request->input('txt_genre_id');
                $item->direccion = $request->input('txt_direccion');
                $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
                $item->ubigeo_id = $idubigeo;
                $item->usertype_id = '2';

                // validar guardado
                if ($item->save()) {
                    // recoger id insertado
                    $newUserId = $item->id;
                    // nuevo objeto
                    $item2 = new Teacher();
                    $item2->teachercontracttype_id = $request->input('txt_tipocontrato');
                    $item2->estado = $request->input('txt_estado');
                    $item2->teachertype_id = $request->input('txt-teachertypes');
                    $item2->user_id = $newUserId;

                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                    }
                    return response()->json(["status" => true, "mensaje" => 'Registro insertado']);
                } else {
                    return response()->json(["status" => false, "mensaje" => 'Registro no insertado']);
                }
            }
        }
    }

    public function update(Request $request, $id)
    {

        $item = User::find($id);

        if (!$item) {
            abort(404); // Manejo de error si no se encuentra el registro
        } else {

            $item->identificationtype_id = $request->input('txt-identificationtype');
            $item->nroidenti = $request->input('txt_nroidenti');
            $item->estado = $request->input('txt_acceso');
            $item->genre_id = $request->input('txt_genre_id');
            $item->nombres = ucwords(strtolower($request->input('txt_nombres')));
            $item->apellido_pa = ucwords(strtolower($request->input('txt_apellido_pa')));
            $item->apellido_ma = ucwords(strtolower($request->input('txt_apellido_ma')));
            $item->fecnac = $request->input('txt_fecnac');
            $item->correo = $request->input('txt_correo');
            $item->telefono = $request->input('txt_telefono');
            $item->celular = $request->input('txt_celular');
            $item->direccion = $request->input('txt_direccion');
            $idubigeo = $request->input('txt_departamento') . $request->input('txt_provincia') . $request->input('txt_distrito');
            $item->ubigeo_id = $idubigeo;
            // validar guardado
            if ($item->save()) {
                // nuevo objeto
                $item2 = new Teacher();

                $item2 = Teacher::where('user_id', $id)->first();
                // validar existencia del registro
                if (!$item2) {
                    abort(404);
                } else {
                    // recoger datos
                    $item2->teachercontracttype_id = $request->input('txt_tipocontrato');
                    $item2->teachertype_id = $request->input('txt-teachertypes');
                    $item2->estado = $request->input('txt_estado');
                    // validar guardado
                    if ($item2->save()) {
                        return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
                    } else {
                        return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
                    }
                }
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function destroy($id)
    {
        // Busca el registro por su ID
        $usuario = User::find($id);
        $idusertype = $usuario->usertype_id;

        // SI SOLO ES DOCENTE
        if ($idusertype == '2') {
            // Verifica si el registro existe
            if (!$usuario) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error, el registro no existe'
                ]);
            }
            // validar eliminación
            if ($usuario->delete()) {
                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
        // SI TIENE OTROS ROLES
        else {

            // eliminar registro del docente
            $docente = Teacher::where('user_id', $usuario->id)->first();
            if (!$docente) {
                return response()->json([
                    "status" => false,
                    "mensaje" => 'Error, el registro no existe'
                ]);
            }
            // validar eliminación
            if ($docente->delete()) {

                // actualizar tipo de usuario
                if ($idusertype == '4') {
                    $new_idusertype = 1;
                } else if ($idusertype == '6') {
                    $new_idusertype = 3;
                } else if ($idusertype == '7') {
                    $new_idusertype = 5;
                }
                $usuario->usertype_id = $new_idusertype;
                $usuario->save();

                return response()->json(["status" => true, "mensaje" => 'El registro fue eliminado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'El registro no fue eliminado']);
            }
        }
    }

    public function update_password(Request $request, $id)
    {
        $item = User::find($id);

        // validar existencia del registro
        if (!$item) {
            abort(404);
        } else {
            // recoger datos
            $item->password = $request->input('txt_password2');
            // validar guardado
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Registro actualizado']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Registro no actualizado']);
            }
        }
    }

    public function ajax_all(Request $request)
    {
        if ($request->ajax()) {
            // $data = Teacher::all();
            $data = DB::table('docentes as t')
                ->join('usuarios as u', 't.user_id', '=', 'u.id')
                ->join('tipos_identificaciones AS it', 'it.id', '=', 'u.identificationtype_id')
                ->join('tipos_contratos_docentes AS tct', 'tct.id', '=', 't.teachercontracttype_id')
                ->select(
                    'u.id as iduser',
                    'it.id AS ididentificationtype',
                    'it.tipo AS tipoidenti',
                    'u.nroidenti',
                    'u.nombres',
                    'u.apellido_pa',
                    'u.apellido_ma',
                    'u.fecnac',
                    'u.correo',
                    'u.telefono',
                    'u.celular',
                    'u.direccion',
                    'u.estado',
                    't.id as idteacher',
                    'tct.id AS idteachercontracttype',
                    'tct.tipo AS tipocontrato',
                    't.horas_lectivas',
                    't.horas_nolectivas',
                    't.estado',
                    't.teachertype_id'
                )
                ->orderBy('u.apellido_pa', 'asc')
                ->get();
            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }

    public function downloadExcelFile(Request $request)
    {

        $fileName = 'public/Plantillainscripciones/Plantilla_docentes.xlsx';

        // Verificar si el archivo existe
        if (Storage::disk('local')->exists($fileName)) {
            // Obtener el archivo del storage

            $file = storage_path('app/'.$fileName);

            $plantilla = IOFactory::load($file);

            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');
            // header("Content-Length: " . filesize($carpeta . $archivo));
            // Crear un escritor y enviar el archivo al flujo de salida

            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            // Mostrar un error
            return abort(404);
        }
    }


    public function store_plantilla(Request $request)
    {
        $datos = $request->input('datajsondos');
        $countUsers = 0;
        $countStudents = 0;
        $countrepetido = 0;
        $miArraynroidentiRepet = [];
        foreach ($datos as $dato) {

            $user = User::where('nroidenti', $dato[1])->first(); // Buscar el usuario por su nroidenti

            if ($user) {
                $countrepetido++;
                array_push($miArraynroidentiRepet, $dato[1]);
            } else {

                $item = new User();

                // TIPO IDENTI
                if($dato[0] === 'DNI') {
                    $idtype=1;
                } else if($dato[0] === 'Carnét de Extranjería') {
                    $idtype=2;
                }
                $item->identificationtype_id = $idtype;

                $item->nroidenti = $dato[1];
                $item->password = $dato[2];
                $item->nombres = $dato[3];
                $item->apellido_pa = $dato[4];
                $item->apellido_ma = $dato[5];

                // Convertir el número de Excel a una fecha legible con Carbon
                $baseDate = Carbon::createFromDate(1900, 1, 1);
                $date = $baseDate->addDays($dato[6] - 2); // Restamos 2 días ya que Excel considera el 1 de enero de 1900 como el día 1

                // Formatear la fecha a tu preferencia antes de insertarla en la base de datos
                $item->fecnac = $date->toDateString();

                $item->correo = $dato[11];
                $item->telefono = $dato[12];
                $item->celular = $dato[13];
                $item->direccion = $dato[14];
                $item->estado = "1";

                $item->ubigeo_id = "100101";    // ICA - ICA - ICA

                // GENERO
                if ($dato[15] === 'Masculino') { $idgenre = '1'; } 
                else if ($dato[15] === 'Femenino') { $idgenre = '2'; } 
                else if ($dato[15] === 'Otros') { $idgenre = '3'; }
                $item->genre_id = $idgenre;

                $item->usertype_id = '2';

                // validar guardado
                if ($item->save()) {
                    $countUsers++;
                    // recoger id insertado
                    $newUserId = $item->id;
                    // nuevo objeto
                    $item2 = new Teacher();
                    // recoger datos
                    if ($dato[7] === 'Estable') {
                        $item2->teachertype_id = '1';
                    } else if ($dato[7] === 'Nombrado') {
                        $item2->teachertype_id = '2';
                    } 

                    if ($dato[8] === 'Tiempo Completo') {
                        $item2->teachercontracttype_id = '1';
                    } else if ($dato[8] === 'Tiempo Parcial') {
                        $item2->teachercontracttype_id = '2';
                    } else if ($dato[8] === 'Por servicio determinado') {
                        $item2->teachercontracttype_id = '3';
                    } else if ($dato[8] === 'Por tiempo determinado') {
                        $item2->teachercontracttype_id = '4';
                    } else if ($dato[8] === 'Indefinido') {
                        $item2->teachercontracttype_id = '5';
                    } else  if ($dato[8] === 'Temporal') {
                        $item2->teachercontracttype_id = '6';
                    }
                    $item2->horas_lectivas = $dato[9];
                    $item2->horas_nolectivas = $dato[10];
                    $item2->estado = 1;

                    $item2->user_id = $newUserId;
                    // validar guardado
                    if ($item2->save()) {
                        $countStudents++;
                    }
                }
            }
        }

        if ($countUsers == count($datos) && $countStudents == count($datos)) {
            $result = ["status" => true, "mensaje" => 'Registros insertados correctamente'];
        } else if (($countUsers > 1 && $countrepetido > 1)) {
            $result = ["status" => true, "mensaje" => 'Registros Insertados: ' . $countUsers . ' Registros no insertados: ' . $countrepetido, "Repet" => $miArraynroidentiRepet];
        } else {
            $result = ["status" => false, "mensaje" => 'Error al insertar plantilla'];
        }
        return response()->json($result);

        // Comprobar si todos los datos se insertaron

    }
}
