<?php

namespace App\Http\Controllers\alumno;

use App\Http\Controllers\Controller;
use App\Http\Controllers\header\HeaderController;
use App\Http\Controllers\sidebar\SidebarController;
use App\Models\Jpjob;
use App\Models\Jpjobapplication;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use \Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Storage;
use Yajra\DataTables\Facades\DataTables;

class AlumnoOfertasLaboralesController extends Controller
{
    //

    public function index(Request $request)
    {

        if (Auth::check()) {
            $userTypeAccesocombo = $request->session()->get('userTypeAccesocombo');
            if ($userTypeAccesocombo == "3") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                $tipoacceso = 3;
                return view('alumno.ofertas_laborales.index')->with('datatipoacceso', $tipoacceso);
            } else if ($userTypeAccesocombo == "1") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.adm.dashboard')->withSuccess('Opps! You do not have access');
            } else if ($userTypeAccesocombo == "2") {
                //si el usuario esta autentificado es docente o estudiante no le pasamos la lista del sidebar
                return redirect()->route('home.docente.index')->withSuccess('Opps! You do not have access');
            }
        } else {
            return redirect()->route('login')->withSuccess('Opps! You do not have access');
        }
    }


    public function listar(Request $request)
    {
        if ($request->ajax()) {
            $pagina = $request->input('pagina');
            $orden = $request->input('orden');
            $departamento = $request->input('departamento');
            $categoria = $request->input('categoria');
            $empresa = $request->input('empresa');
            $buscar = $request->input('buscar');

            $data = DB::table('bt_trabajos as job')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->select(
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito'
                )
                ->where('job.estado', '=', '1')
                ->whereDate('job.feccierre', '>=', now()->toDateString());

            $data = $data->orderBy('job.fecpublicacion', $orden)->orderBy('job.id',  $orden);

            if ($departamento != "all") {
                $data = $data->where('ubi.departamento', '=', $departamento);
            }

            if ($categoria != "all") {
                $data = $data->where('cat.nombre', '=', $categoria);
            }

            if ($empresa != "all") {
                $data = $data->where('com.nombre', '=', $empresa);
            }

            if ($buscar != "default") {
                $data = $data->where('puesto', 'LIKE', '%' . $buscar . '%');
            }

            $skip = ($pagina - 1) * 12;

            $data = $data->skip($skip)->take('12')->get();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function cantidad_ofertas(Request $request)
    {
        if ($request->ajax()) {
            $orden = $request->input('orden');
            $departamento = $request->input('departamento');
            $categoria = $request->input('categoria');
            $empresa = $request->input('empresa');
            $buscar = $request->input('buscar');

            $data = DB::table('bt_trabajos as job')
                ->join('bt_empresas as com', 'job.jpcompany_id', '=', 'com.id')
                ->join('bt_categorias as cat', 'job.jpcategory_id', '=', 'cat.id')
                ->join('ubigeos as ubi', 'job.ubigeo_id', '=', 'ubi.id')
                ->select(
                    'job.id as idjob',
                    'job.puesto',
                    'job.vacantes',
                    'job.tipo',
                    'job.modalidad',
                    'job.experiencia',
                    'job.fecpublicacion',
                    'job.feccierre',
                    'job.salariomin',
                    'job.salariomax',
                    'job.nivel_educativo',
                    'job.descripcion',
                    'job.estado',
                    'com.id as idcompany',
                    'com.nombre as nombrecompany',
                    'cat.id as idcategory',
                    'cat.nombre as nombrecategory',
                    'ubi.id as idubigeo',
                    DB::raw('SUBSTRING(ubi.id, 1, 2) as iddepartamento'),
                    'ubi.departamento',
                    DB::raw('SUBSTRING(ubi.id, 3, 2) as idprovincia'),
                    'ubi.provincia',
                    DB::raw('SUBSTRING(ubi.id, 5, 2) as iddistrito'),
                    'ubi.distrito'
                )
                ->where('job.estado', '=', '1')
                ->whereDate('job.feccierre', '>=', now()->toDateString());

            if ($orden == "default") {
                $data = $data->orderBy('job.fecpublicacion', 'desc')->orderBy('job.id', 'desc');
            } else {
                $data = $data->orderBy('job.fecpublicacion', $orden);
            }

            if ($departamento != "all") {
                $data = $data->where('ubi.departamento', '=', $departamento);
            }

            if ($categoria != "all") {
                $data = $data->where('cat.nombre', '=', $categoria);
            }

            if ($empresa != "all") {
                $data = $data->where('com.nombre', '=', $empresa);
            }

            if ($buscar != "default") {
                $data = $data->where('puesto', 'LIKE', '%' . $buscar . '%');
            }

            $data = $data->count();

            return response()->json($data);
        }
        return  response()->json(["status" => false, "mensaje" => 'Error en request']);
    }


    public function store(Request $request)
    {
        // validar documento
        $validator = Validator::make($request->all(), [
            'txt-documento' => 'required|file|mimes:pdf,jpg,png|max:2000', // Valida PDF y tamaño máximo de 2MB
        ], [
            'txt-documento.file' => 'El archivo PDF es requerido.',
            'txt-documento.mimes' => 'El archivo debe ser un PDF.',
            'txt-documento.max' => 'El tamaño del archivo no debe superar los 2000 KB.',
        ]);
        // documento inválido
        if ($validator->fails()) {
            return response()->json([
                "status" => 'validators', "mensaje" => $validator->errors(),
            ]);
        } else {

            $user = Auth::user();
            $studentdata = $user->students;
            $idstudent = $studentdata[0]->id;
            $idjob = $request->input('txt-idjob');
            $idcompany = $request->input('txt-idcompany');

            // Obtener la fecha y hora actual
            $fechaActual = Carbon::now();

            // También puedes formatear la fecha según tus necesidades
            $fechaFormateada = $fechaActual->format('Y-m-d');

            // validar si ya ha postulado al trabajo
            $verificarpostulacion = Jpjobapplication::where('jpjob_id', $idjob)->where('student_id', $idstudent)->first();
            if ($verificarpostulacion) {
                return response()->json(["status" => false, "mensaje" => 'Ya has postulado a este trabajo']);
            }

            // crear registro
            $item = new Jpjobapplication();
            $item->jpjob_id = $idjob;
            $item->student_id = $idstudent;
            $item->fecaplicacion = $fechaFormateada;
            $item->estado = '2';
            $item->isvisto = '0';
            $item->feedback = '--';
            $item->fecfeedback = $fechaFormateada;

            // guardar documento si existe
            if ($request->hasFile('txt-documento')) {
                $folderName = $idcompany . '/' . 'jobs' . '/' . $idjob . '/' . 'jobapplications';
                Storage::disk('local')->makeDirectory('companies/' . $folderName);   // creamos la carpeta en el disco local
                $archivo = $request->file('txt-documento');   // obtenemos el archivo
                $archivo->storeAs('companies/' . $folderName, $idstudent . '.pdf');  // guardado (ruta,nombre del archivo)
                $filePath = 'companies/' . $folderName . '/' . $idstudent . '.pdf';  // ruta del archivo
                $item->documento = $filePath;
            }

            // guardar
            if ($item->save()) {
                return response()->json(["status" => true, "mensaje" => 'Postulación realizada correctamente']);
            } else {
                return response()->json(["status" => false, "mensaje" => 'Postulación no realizada']);
            }
        }
    }
}
