<?php

namespace App\Http\Controllers\planes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use PhpOffice\PhpSpreadsheet\IOFactory;

class DownloadExcelController extends Controller
{
    public function downloadExcelFile(Request $request)
    {
        $tipoplan = $request->input('tipo');
        $nivel_formativo =  $request->input('nivelformativo');
        
        if ($tipoplan === "Modular") {
            if ($nivel_formativo === "Profesional Técnico"){
                $fileName = "public/Plantillaplanes/modular/PLANTILLA_MODULAR_PROFESIONAL.xlsx";
            }else{
                $fileName = "public/Plantillaplanes/modular/PLANTILLA_MODULAR_TECNICO.xlsx";
            }
        } else if ($tipoplan === "Transversal") {
            if ($nivel_formativo === "Profesional Tecnico"){
                $fileName = "public/Plantillaplanes/transversal/PLANTILLA_TRANSVERSAL_PROFESIONAL.xlsx";
            }else{
                $fileName = "public/Plantillaplanes/transversal/PLANTILLA_TRANSVERSAL_TECNICO.xlsx";
            }
        }

        if (Storage::disk('local')->exists($fileName)) {
            $file = storage_path('app/'.$fileName);
            $plantilla = IOFactory::load($file);
            $plan =  $request->input('nombreplan');
            $programa =  $request->input('nombreprograma');
            $modalidad =  $request->input('modalidad');
            $enfoque =  $request->input('enfoque');

            $sheet = $plantilla->getActiveSheet();
            $sheet->setCellValue('E3', $plan)
                ->setCellValue('B3', $programa)
                ->setCellValue('E4', $tipoplan)
                ->setCellValue('B4', $nivel_formativo);

            // Establecer encabezados para forzar la descarga
            header("Content-Disposition: attachment; filename=" . $file);
            header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
            header('Cache-Control: max-age=0');

            $writer = IOFactory::createWriter($plantilla, 'Xlsx');
            $writer->save('php://output');
        } else {
            return abort(404);
        }
    }
}
