<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


/**
 * Class Schedule
 *
 * @property $id
 * @property $scheduleingcalendar_id
 * @property $ruta
 * @property $archivo
 * @property $horaini
 * @property $horafin
 * @property $horaextend
 * @property $duracion
 * @property $created_at
 * @property $updated_at
 *
 * @property Subject $subject
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Assignedprogramming extends Model
{
    protected $table = 'asignar_programacion';

    use HasFactory;

    static $rules = [
        'scheduleingcalendar_id' => 'required',
		'ruta' => 'required',
		'archivo' => 'required',
		'horaini' => 'required',
		'horafin' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['scheduleingcalendar_id','ruta','archivo','horaini','horafin','duracion','horaextend'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */

    public function Scheduleingcalendar()
    {
        return $this->hasOne('App\Models\Scheduleingcalendar', 'id', 'scheduleingcalendar_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function evaluateprogramming()
    {
        return $this->hasOne('App\Models\Evaluateprogramming', 'id', 'assignedprogramming_id');
    }
}
