<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Attendance
 *
 * @property $id
 * @property $subjectclass_id
 * @property $subjectenrollment_id
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Subjectclass[] $subjectclass
 * @property Subjectenrollment $subjectenrollment
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Attendance extends Model
{
    protected $table = 'asistencias';

    static $rules = [
        'subjectclass_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['subjectclass_id', 'subjectenrollment_id', 'estado'];

    /**
     * 
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectclass()
    {
        return $this->hasOne('App\Models\Subjectclass', 'id', 'subjectclass_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subjectenrollment()
    {
        return $this->hasOne('App\Models\Subjectenrollment', 'id', 'subjectenrollment_id');
    }
}




