<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Backuphistory
 *
 * @property $id
 * @property $nombre
 * @property $estado
 * @property $administrator_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Administrator $administrator
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Backuphistory extends Model
{
  protected $table = 'historial_backups';

  static $rules = [
    'administrator_id' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre', 'estado', 'administrator_id'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasOne
   */
  public function administrator()
  {
    return $this->hasOne('App\Models\Administrator', 'id', 'administrator_id');
  }
}
