<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Contentdetail
 *
 * @property $id
 * @property $subtitulo
 * @property $contenido
 * @property $content_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Content[] $admissionplans
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Contentdetail extends Model
{
    protected $table = 'detalles_contenidos';

    use HasFactory;

    static $rules = [
        'content_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['subtitulo', 'contenido', 'content_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function content()
    {
        return $this->hasOne('App\Models\Content', 'id', 'content_id');
    }

}
