<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Course
 *
 * @property $id
 * @property $tipo
 * @property $codcurso
 * @property $nombre
 * @property $codpredecesor
 * @property $horas
 * @property $creditos
 * @property $period_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Period $period
 * @property Subject[] $subjects
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Course extends Model
{
    protected $table = 'cursos';
    
    use HasFactory;

    static $rules = [
        'tipo' => 'required',
        'codcurso' => 'required',
        'nombre' => 'required',
        'period_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['tipo','codcurso','nombre','codpredecesor','horas','creditos','period_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function period()
    {
        return $this->hasOne('App\Models\Period', 'id', 'period_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subjects()
    {
        return $this->hasMany('App\Models\Subject', 'course_id', 'id');
    }


}
