<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Repositorymaterials
 *
 * @property $id
 * @property $subfolder_id
 * @property $ruta
 * @property $archivo
 * @property $created_at
 * @property $updated_at
 *
 * @property Subfolder[] $subfolders
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */

class Folderfile extends Model
{
    use HasFactory;
    protected $table = 'archivos_carpetas';

    static $rules = [
        'subfolder_id' => 'required',
		'ruta' => 'required',
		'archivo' => 'required',
    ];

    protected $perPage = 20;

    protected $fillable = ['subfolder_id','ruta','archivo'];

    public function subfolder()
    {
        return $this->hasOne('App\Models\Subfolder', 'id', 'subfolder_id');
    }
}
