<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Jpjob
 *
 * @property $id
 * @property $puesto
 * @property $vacantes
 * @property $tipo
 * @property $modalidad
 * @property $experiencia
 * @property $fecpublicacion
 * @property $feccierre
 * @property $salariomin
 * @property $salariomax
 * @property $nivel_educativo
 * @property $descripcion
 * @property $estado
 * @property $jpcompany_id
 * @property $jpcategory_id
 * @property $ubigeo_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Jpcategory $jpcategory
 * @property Jpcompany $jpcompany
 * @property Jpjobapplication[] $jpjobapplications
 * @property Jpjobtag[] $jpjobtags
 * @property Ubigeo $ubigeo
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Jpjob extends Model
{
    protected $table = 'bt_trabajos';
    
    static $rules = [
		'puesto' => 'required',
		'vacantes' => 'required',
		'tipo' => 'required',
		'modalidad' => 'required',
		'experiencia' => 'required',
		'fecpublicacion' => 'required',
		'feccierre' => 'required',
		'salariomin' => 'required',
		'salariomax' => 'required',
		'nivel_educativo' => 'required',
		'descripcion' => 'required',
		'estado' => 'required',
		'jpcompany_id' => 'required',
		'jpcategory_id' => 'required',
		'ubigeo_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['puesto','vacantes','tipo','modalidad','experiencia','fecpublicacion','feccierre','salariomin','salariomax','nivel_educativo','descripcion','estado','jpcompany_id','jpcategory_id','ubigeo_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function jpcategory()
    {
        return $this->hasOne('App\Models\Jpcategory', 'id', 'jpcategory_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function jpcompany()
    {
        return $this->hasOne('App\Models\Jpcompany', 'id', 'jpcompany_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function jpjobapplications()
    {
        return $this->hasMany('App\Models\Jpjobapplication', 'jpjob_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function jpjobtags()
    {
        return $this->hasMany('App\Models\Jpjobtag', 'jpjob_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function ubigeo()
    {
        return $this->hasOne('App\Models\Ubigeo', 'id', 'ubigeo_id');
    }
    

}
