<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Plan
 *
 * @property $id
 * @property $nombre
 * @property $tipo
 * @property $modalidad
 * @property $enfoque
 * @property $program_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Admissionplan[] $admissionplans
 * @property Period[] $periods
 * @property Program $program
 * @property Student[] $students
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Plan extends Model
{
    protected $table = 'planes';

    use HasFactory;

    static $rules = [
        'nombre' => 'required',
        'tipo' => 'required',
        'modalidad' => 'required',
        'enfoque' => 'required',
        'program_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['nombre', 'tipo', 'modalidad', 'enfoque', 'fecha', 'documento', 'program_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function admissionplans()
    {
        return $this->hasMany('App\Models\Admissionplan', 'plan_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function periods()
    {
        return $this->hasMany('App\Models\Period', 'plan_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function planequivalences2()
    {
        return $this->hasMany('App\Models\Planequivalence', 'plan_id2', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function planequivalences1()
    {
        return $this->hasMany('App\Models\Planequivalence', 'plan_id1', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function program()
    {
        return $this->hasOne('App\Models\Program', 'id', 'program_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function students()
    {
        return $this->hasMany('App\Models\Student', 'plan_id', 'id');
    }
}
