<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class Program
 *
 * @property $id
 * @property $codprograma
 * @property $nombre
 * @property $nivel_formativo
 * @property $created_at
 * @property $updated_at
 *
 * @property Plan[] $plans
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Program extends Model
{
  protected $table = 'programas';

  use HasFactory;

  static $rules = [
    'codprograma' => 'required',
    'nombre' => 'required',
    'nivel_formativo' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['codprograma', 'nombre', 'nivel_formativo'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function plans()
  {
    return $this->hasMany('App\Models\Plan', 'program_id', 'id');
  }
}
