<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Schedule
 *
 * @property $id
 * @property $dia
 * @property $horaini
 * @property $horafin
 * @property $duracion
 * @property $subject_id
 * @property $classroom_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Classroom $classroom
 * @property Subject $subject
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Schedule extends Model
{
    protected $table = 'horarios';

    static $rules = [
        'dia' => 'required',
        'horaini' => 'required',
        'horafin' => 'required',
        'subject_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['dia', 'horaini', 'horafin', 'duracion', 'subject_id', 'classroom_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function classroom()
    {
        return $this->hasOne('App\Models\Classroom', 'id', 'classroom_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subject()
    {
        return $this->hasOne('App\Models\Subject', 'id', 'subject_id');
    }
}
