<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


/**
 * Class Schedule
 *
 * @property $id
 * @property $subject_id
 * @property $nombre_evento
 * @property $gradetype_id
 * @property $fecinicio
 * @property $horario
 * @property $descripcion
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Subject $subject
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Scheduleingcalendar extends Model
{

    protected $table = 'calendario_programacion';

    use HasFactory;


    static $rules = [
        'subject_id' => 'required',
        'gradetype_id' => 'required',
		'nombre_evento' => 'required',
		'fecinicio' => 'required',
		'horaini' => 'required',
		'horafin' => 'required',
		'duracion' => 'required',
		'ruta' => 'required',
		'archivo' => 'required',
		'descripcion' => 'required',
		'estado' => 'required'
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['subject_id','gradetype_id','nombre_evento','fecinicio','horaini','horafin','duracion','ruta','archivo','descripcion','estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */

    public function subject()
    {
        return $this->hasOne('App\Models\Subject', 'id', 'subject_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */

    public function evaluateprogramming()
    {
        return $this->hasOne('App\Models\Evaluateprogramming', 'scheduleingcalendar_id', 'id');
    }

        /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */

    public function gradetype()
    {
        return $this->hasOne('App\Models\Gradetype', 'id', 'gradetype_id');
    }
}
