<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Semesterperiod
 *
 * @property $id
 * @property $semester_id
 * @property $period_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Period $period
 * @property Semester $semester
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Semesterperiod extends Model
{
    protected $table = 'periodos_semestres';

    static $rules = [
        'semester_id' => 'required',
        'period_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['semester_id', 'period_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function period()
    {
        return $this->hasOne('App\Models\Period', 'id', 'period_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function semester()
    {
        return $this->hasOne('App\Models\Semester', 'id', 'semester_id');
    }
}
