<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Socioeconomicsheet
 *
 * @property $id
 * @property $estado_civil
 * @property $nro_hijos
 * @property $ingreso_mensual
 * @property $ocupacion
 * @property $empresa
 * @property $tipovivienda
 * @property $gastos_mensuales
 * @property $flg_trabaja
 * @property $rubro_empresa
 * @property $tipo_empresa
 * @property $nombre_jefe
 * @property $forma_contrato
 * @property $flg_antes_trabajaba
 * @property $meses_no_trabaja
 * @property $explicacion
 * @property $form_prof_recibida
 * @property $carrera_satis_necesi
 * @property $area_carrera_profesiona_beneficiado
 * @property $satisfecho_form_institu_brindo
 * @property $motivos_satisfecho_form_institu_brindo
 * @property $razon_form_institu_brindo
 * @property $student_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Student $student
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Socioeconomicsheet extends Model
{
    protected $table = 'fichas_socioeconomicas';

    static $rules = [
        'estado_civil' => 'required',
        'nro_hijos' => 'required',
        'ingreso_mensual' => 'required',
        'ocupacion' => 'required',
        'empresa' => 'required',
        'tipovivienda' => 'required',
        'gastos_mensuales' => 'required',
        'flg_trabaja' => 'required',
        'rubro_empresa' => 'required',
        'tipo_empresa' => 'required',
        'nombre_jefe' => 'required',
        'forma_contrato' => 'required',
        'flg_antes_trabajaba' => 'required',
        'meses_no_trabaja' => 'required',
        'explicacion' => 'required',
        'form_prof_recibida' => 'required',
        'carrera_satis_necesi' => 'required',
        'area_carrera_profesiona_beneficiado' => 'required',
        'satisfecho_form_institu_brindo' => 'required',
        'motivos_satisfecho_form_institu_brindo' => 'required',
        'razon_form_institu_brindo' => 'required',
        'student_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = [
        'estado_civil',
        'nro_hijos',
        'ingreso_mensual',
        'ocupacion',
        'empresa',
        'tipovivienda',
        'gastos_mensuales',
        'flg_trabaja',
        'rubro_empresa',
        'tipo_empresa',
        'nombre_jefe',
        'forma_contrato',
        'flg_antes_trabajaba',
        'meses_no_trabaja',
        'explicacion',
        'form_prof_recibida',
        'carrera_satis_necesi',
        'area_carrera_profesiona_beneficiado',
        'satisfecho_form_institu_brindo',
        'motivos_satisfecho_form_institu_brindo',
        'razon_form_institu_brindo',
        'student_id',
    ];

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }
}
