<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Subjectenrollment
 *
 * @property $id
 * @property $student_id
 * @property $subject_id
 * @property $nota
 * @property $estado
 * @property $created_at
 * @property $updated_at
 *
 * @property Student $student
 * @property Subject $subject
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Subjectenrollment extends Model
{
    protected $table = 'matriculas_asignaturas';

    static $rules = [
        'student_id' => 'required',
        'subject_id' => 'required',
        'nota' => 'required',
        'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['student_id', 'subject_id', 'nota', 'estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function subject()
    {
        return $this->hasOne('App\Models\Subject', 'id', 'subject_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function attendance()
    {
        return $this->hasMany('App\Models\Attendance', 'subjectenrollment_id', 'id');
    }
}
