<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

/**
 * Class TdRequestType
 *
 * @property $id
 * @property $nombre
 * @property $created_at
 * @property $updated_at
 *
 * @property TdRequest[] $td_requests
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class TdRequestType extends Model
{
  protected $table = 'td_request_types';

  use HasFactory;

  static $rules = [
    'nombre' => 'required',
  ];

  protected $perPage = 20;

  /**
   * Attributes that should be mass-assignable.
   *
   * @var array
   */
  protected $fillable = ['nombre'];


  /**
   * @return \Illuminate\Database\Eloquent\Relations\HasMany
   */
  public function td_requests()
  {
    return $this->hasMany('App\Models\TdRequest', 'td_request_type_id', 'id');
  }
}
