<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Tddocument
 *
 * @property $id
 * @property $codigosolicitud
 * @property $termino
 * @property $tipo_documento
 * @property $folio
 * @property $asunto
 * @property $estado
 * @property $ubigeo_id
 * @property $student_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Student $student
 * @property Tdfile[] $tdfiles
 * @property Tdmovement[] $tdmovements
 * @property Tdvoucher[] $tdvouchers
 * @property Ubigeo $ubigeo
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Tddocument extends Model
{
    protected $table = 'td_documentos';
    
    static $rules = [
		'student_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['codigosolicitud','termino','tipo_documento','folio','asunto','estado','ubigeo_id','student_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function student()
    {
        return $this->hasOne('App\Models\Student', 'id', 'student_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tdfiles()
    {
        return $this->hasMany('App\Models\Tdfile', 'tddocument_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tdmovements()
    {
        return $this->hasMany('App\Models\Tdmovement', 'tddocument_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tdvouchers()
    {
        return $this->hasMany('App\Models\Tdvoucher', 'tddocument_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function ubigeo()
    {
        return $this->hasOne('App\Models\Ubigeo', 'id', 'ubigeo_id');
    }
    

}
