<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**

 */
class TdFile extends Model
{
  protected $table = 'td_files';
    
    static $rules = [
		'td_request_id' => 'required',
		'nro_item' => 'required',
		'nombre' => 'required',
		'ruta' => 'required',
		'estado' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['td_request_id','nro_item','nombre','ruta','estado'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function td_request()
    {
        return $this->hasOne('App\Models\TdRequest', 'id', 'td_request_id');
    }
    

}
