<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Tdmovement
 *
 * @property $id
 * @property $areaorigen
 * @property $areadestino
 * @property $descripcion
 * @property $fecha_aprobado
 * @property $estado
 * @property $tddocument_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Tddocument $tddocument
 * @property Tdfilemovement[] $tdfilemovements
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Tdmovement extends Model
{
    protected $table = 'td_movimientos';
    
    static $rules = [
		'tddocument_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['areaorigen','areadestino','descripcion','fecha_aprobado','estado','tddocument_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function tddocument()
    {
        return $this->hasOne('App\Models\Tddocument', 'id', 'tddocument_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function tdfilemovements()
    {
        return $this->hasMany('App\Models\Tdfilemovement', 'tdmovement_id', 'id');
    }
    

}
