<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class Teacher
 *
 * @property $id
 * @property $tipocontrato
 * @property $horas_lectivas
 * @property $horas_nolectivas
 * @property $estado
 * @property $user_id
 * @property $teachertype_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Subject[] $subjects
 * @property Teachertype $teachertype
 * @property User $user
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class Teacher extends Model
{
    protected $table = 'docentes';
    
    static $rules = [
		'tipocontrato' => 'required',
		'horas_lectivas' => 'required',
		'horas_nolectivas' => 'required',
		'estado' => 'required',
		'user_id' => 'required',
		'teachertype_id' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['tipocontrato','horas_lectivas','horas_nolectivas','estado','user_id','teachertype_id'];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function subjects()
    {
        return $this->hasMany('App\Models\Subject', 'teacher_id', 'id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function teachertype()
    {
        return $this->hasOne('App\Models\Teachertype', 'id', 'teachertype_id');
    }
    
    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function user()
    {
        return $this->hasOne('App\Models\User', 'id', 'user_id');
    }
    

}
