<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

/**
 * Class User
 *
 * @property $id
 * @property $identificationtype_id
 * @property $nroidenti
 * @property $password
 * @property $nombres
 * @property $apellido_pa
 * @property $apellido_ma
 * @property $fecnac
 * @property $correo
 * @property $telefono
 * @property $celular
 * @property $direccion
 * @property $estado
 * @property $ubigeo_id
 * @property $genre_id
 * @property $usertype_id
 * @property $created_at
 * @property $updated_at
 *
 * @property Administrator[] $administradores
 * @property Genre $genre
 * @property Student[] $students
 * @property Teacher[] $teachers
 * @property Ubigeo $ubigeo
 * @property Usertype $usertype
 * @package App
 * @mixin \Illuminate\Database\Eloquent\Builder
 */
class User extends Authenticatable
{
    protected $table = 'usuarios';

    use HasApiTokens, HasFactory, Notifiable;

    static $rules = [
        'identificationtype_id' => 'required',
        'nroidenti' => 'required',
    ];

    protected $perPage = 20;

    /**
     * Attributes that should be mass-assignable.
     *
     * @var array
     */
    protected $fillable = ['identificationtype_id', 'nroidenti', 'nombres', 'apellido_pa', 'apellido_ma', 'fecnac', 'correo', 'telefono', 'celular', 'direccion', 'estado', 'ubigeo_id', 'genre_id', 'usertype_id'];


    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        // 'remember_token',
    ];


    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        // 'email_verified_at' => 'datetime',
        'password' => 'hashed',
    ];


    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function administradores()
    {
        return $this->hasMany('App\Models\Administrator', 'user_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function genre()
    {
        return $this->hasOne('App\Models\Genre', 'id', 'genre_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function students()
    {
        return $this->hasMany('App\Models\Student', 'user_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasMany
     */
    public function teachers()
    {
        return $this->hasMany('App\Models\Teacher', 'user_id', 'id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function ubigeo()
    {
        return $this->hasOne('App\Models\Ubigeo', 'id', 'ubigeo_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function usertype()
    {
        return $this->hasOne('App\Models\Usertype', 'id', 'usertype_id');
    }

    /**
     * @return \Illuminate\Database\Eloquent\Relations\HasOne
     */
    public function identificationtype()
    {
        return $this->hasOne('App\Models\Identificationtype', 'id', 'identificationtype_id');
    }
}
