"use strict";

var dlabSettingsOptions = {};

function getUrlParams(dParam) {
    var dPageURL = window.location.search.substring(1),
        dURLVariables = dPageURL.split("&"),
        dParameterName,
        i;

    for (i = 0; i < dURLVariables.length; i++) {
        dParameterName = dURLVariables[i].split("=");

        if (dParameterName[0] === dParam) {
            return dParameterName[1] === undefined
                ? true
                : decodeURIComponent(dParameterName[1]);
        }
    }
}

/* Cookies Function */
function setCookie(cname, cvalue, exhours) {
    // console.log('cname: '+cname);
    // console.log('cvalue: '+cvalue);
    var d = new Date();
    d.setTime(d.getTime() + (exhours * 60 * 60 * 1000)); /* exhours hours */
    var expires = "expires=" + d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    //new
    var dc = document.cookie;
    var prefix = cname + "=";
    var begin = dc.indexOf(prefix);

    if (begin == -1) {
        return null; // Cookie no encontrada
    }

    begin += prefix.length;
    var end = dc.indexOf(";", begin);

    if (end == -1) {
        end = dc.length;
    }

    return decodeURIComponent(dc.substring(begin, end));
}

function deleteCookie(cname) {
    var d = new Date();
    d.setTime(d.getTime() + 1); // 1/1000 second
    var expires = "expires=" + d.toString();
    //document.cookie = cname + "=1;" + expires + ";path=/";
    document.cookie =
        cname + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT" + ";path=/";
}

function deleteAllCookie(reload = true) {
    jQuery.each(themeOptionArr, function (optionKey, optionValue) {
        deleteCookie(optionKey);
    });
    if (reload) {
        location.reload();
    }
}

/* Cookies Function END */

(function ($) {
    "use strict";

    var version = getCookie('version')
    // console.log('version desde dlabnav: '+version)

    // dlabSettingsOptions = {
    //     typography: "poppins",
    //     version: version || "light",
    //     layout: "vertical",
    //     primary: "color_3",
    //     headerBg: "color_1",
    //     navheaderBg: "color_3",
    //     sidebarBg: "color_3",
    //     sidebarStyle: "full",
    //     sidebarPosition: "fixed",
    //     headerPosition: "fixed",
    //     containerLayout: "full",
    // };

    dlabSettingsOptions = {
        typography: "poppins",
        version: version || "light",
        layout: "vertical",
        primary: "color_7",
        headerBg: "color_1",
        navheaderBg: "color_7",
        sidebarBg: "color_7",
        sidebarStyle: "full",
        sidebarPosition: "fixed",
        headerPosition: "fixed",
        containerLayout: "full",
    };

    new dlabSettings(dlabSettingsOptions);

    jQuery(window).on("resize", function () {
        /*Check container layout on resize */
        ///alert(dlabSettingsOptions.primary);
        dlabSettingsOptions.containerLayout = $("#container_layout").val();
        /*Check container layout on resize END */

        new dlabSettings(dlabSettingsOptions);
    });
})(jQuery);
