"use strict";

(function () {

    var chartBarDonutsex = function () {
            // RESPUESTA HTTP
            function checkStatus(response) {
                if (response.status >= 200 && response.status < 300) {
                    return response;
                } else {
                    var error = new Error(response.statusText)
                    error.response = response
                    throw error
                }
            }

            function parseJSON(response) {
                return response.json()
            }

            // FUNCIÓN RESPUESTAS EN TOAST
            function fuctionRespuesta(response) {

                var generomasculino = 0;
                var generofemenino = 0;
                var generoprefieronodecirlo = 0;
                var generootro =0;
                var nobinario =0;



                response.data.forEach((elemento) => {
                    if (elemento.nombre === "Femenino") {
                        generofemenino = parseInt(elemento.datatotal);
                    } else if (elemento.nombre === "Masculino") {
                        generomasculino = parseInt(elemento.datatotal);
                    }else if (elemento.nombre === "No binario") {
                        nobinario = parseInt(elemento.datatotal);
                    }else  if (elemento.nombre === "Otro") {
                        generootro = parseInt(elemento.datatotal);
                    }else if (elemento.nombre === "Prefiero no decirlo"){
                        generoprefieronodecirlo = parseInt(elemento.datatotal);
                    }

                });

                var total = generomasculino + generofemenino + generoprefieronodecirlo + generootro +nobinario;

                const chartOrderStatistics3 = document.querySelector(
                    "#orderStatisticsChart3"
                ),
                    orderChartConfig3 = {
                        chart: {
                            height: 165,
                            width: 130,
                            type: "donut",
                        },
                        labels: ["Masculino", "Femenino","No binario", "Prefiero no decirlo", "Otro"],
                        series: [generomasculino, generofemenino,nobinario, generoprefieronodecirlo, generootro],
                        colors: ['#00273A', '#FB7D5B',"#fd108d", '#09CBC6','#433AB2'],
                        stroke: {
                            width: 3,
                            colors: "#ffffff",
                        },
                        dataLabels: {
                            enabled: true,
                            formatter: function (val, opt) {
                                return parseInt(val) + "%";
                            },
                        },
                        legend: {
                            show: false,
                        },
                        grid: {
                            padding: {
                                top: 0,
                                bottom: 0,
                                right: 15,
                            },
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    position: 'center',
                                    size: "65%",
                                    labels: {
                                        show: true,
                                        value: {
                                            fontSize: "18px",
                                            fontFamily: "poppins",
                                            color: "#757371",
                                            offsetY: -15,
                                            formatter: function (val) {
                                                return parseInt(val) + "";
                                            },
                                        },
                                        name: {
                                            offsetY: 20,
                                            fontFamily: "poppins",
                                        },
                                        total: {
                                            show: true,
                                            fontSize: "0.8125rem",
                                            color: "#fff",
                                            label: "Totales",
                                            formatter: function (w) {
                                                return total;
                                            },
                                        },
                                    },
                                },
                            },
                        },
                    };
                if (
                    typeof chartOrderStatistics3 !== undefined &&
                    chartOrderStatistics3 !== null
                ) {
                    const statisticsChart3 = new ApexCharts(
                        chartOrderStatistics3,
                        orderChartConfig3
                    );
                    statisticsChart3.render();
                }

            }

            // CONSULTA A LA BD
            fetch(routeDashboardgraficadonusdos,
                {
                  method: "GET",
                })
                .then(checkStatus)
                .then(parseJSON)
                .then((response) => {
                    fuctionRespuesta(response);
                })
                .catch(function (error) {
                    console.log('request failed', error)
                })
    }


    chartBarDonutsex();

})();
