import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";

window.addEventListener("DOMContentLoaded", async () => {
    var cboPrograma = document.querySelector("#cb_programa");

    cboPrograma.addEventListener("change", async function (e) {
        var select = document.getElementById("cb_programa");
        document.getElementById("cboProgramaName").value = select.options[select.selectedIndex].text;
    })

    var js_btnDonwload_Plantilla = document.querySelector(
        "#btnDonwload_Plantilla"
    );


    js_btnDonwload_Plantilla.addEventListener("click", async function (e) {
        e.preventDefault();

        if (document.getElementById("text_nombreplan").value === "") {
            notificaciontoast("error", "Debe llenar el nombre del plan");
            return;
        }

        if (document.getElementById("cb_programa").value === "0") {
            notificaciontoast("error", "Debe Seleccionar un programa");
            return;
        }

        if (document.getElementById("cb_tipoplan").value === "") {
            notificaciontoast("error", "Debe Seleccionar un plan");
            return;
        }

        if (document.getElementById("cb_modalidad").value === "") {
            notificaciontoast("error", "Debe Seleccionar una modalidad");
            return;
        }

        if (document.getElementById("cb_enfoque").value === "") {
            notificaciontoast("error", "Debe Seleccionar un enfoque");
            return;
        }

        var tipoplan = document.getElementById("cb_tipoplan").value;
        var nivelFormativo = quitarTildes(window.nivelSeleccionado);
        // nivelFormativo = encodeURIComponent(nivelFormativo);
        var nombreArchivo = "PLANTILLA_" + tipoplan.toUpperCase() + "_" + nivelFormativo.toUpperCase() + ".xlsx";
        var formData = new FormData(document.getElementById("form"));

        formData.append('nivel_formativo', nivelFormativo);
        console.log(formData)
        fetch(route_download, {
            method: "POST",
            body: formData,
        })
            .then((response) => response.blob())
            .then((blob) => {
                // Crea un objeto URL para el blob
                var url = window.URL.createObjectURL(blob);
                // Crea un enlace para descargar el archivo
                var a = document.createElement("a");
                a.href = url;
                a.download = nombreArchivo;
                document.body.appendChild(a);
                a.click();
                // Libera el objeto URL
                window.URL.revokeObjectURL(url);
            })
            .catch((error) => {
                notificaciontoast("Error al descargar el archivo:", error);
            });
    });
});


function quitarTildes(cadena) {
    var mapaDeAcentosYLetras = {
        á: 'a',
        é: 'e',
        í: 'i',
        ó: 'o',
        ú: 'u',
        Á: 'A',
        É: 'E',
        Í: 'I',
        Ó: 'O',
        Ú: 'U'
    };

    var nuevaCadena = cadena.replace(/[áéíóúÁÉÍÓÚ]/g, function (letra) {
        return mapaDeAcentosYLetras[letra];
    });

    return nuevaCadena;
}
