import { notificaciontoast } from '../jsAjaxToastSweetalert/method_toast.js'
import { confirmation_sweetAlert } from '../jsAjaxToastSweetalert/method_sweetAlert.js'

$(document).ready(function () {
  const tableName = 'Programas';

  var dt_idsemester = "0", dt_idplan = "0", dt_idperiod = "0";
  var formModal;

  var table = $('#datatableGeneral').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: routeList,
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: 'Reporte del ',
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: { columns: ':visible', orthogonal: 'print' }
      },
      {
        extend: 'pdf',
        title: 'Reporte: Registros de los administradores ',
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: { columns: ':visible', orthogonal: 'print' }
      },
      {
        extend: 'print',
        title: 'Reporte: Registros de los administradores ',
        type: 'button',
        orientation: 'landscape',
        className: 'btn  btn-sm btn-arounded',
        exportOptions: { columns: ':visible', orthogonal: 'print' }
      },
      {
        extend: 'colvis',
        text: 'Seleccionar celdas',
        title: 'Reporte: Registros de los administradores ',
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: { columns: ':visible', orthogonal: 'print' }
      }
    ],
    columns: [
      {
        data: "idplan",
        className: "text-center",
        render: function (data, type, all, meta) {
          return "<h4>" + all.nombreprograma + "</h4>" +
            "<br>" +
            "<b> Nivel Formativo: </b>" + all.nivelformativo
        },
        // name: "primero",
      },
      {
        data: 'nombreplan',
        className: 'text-center'
      },
      {
        data: 'tipo',
        className: 'text-start'
      },
      {
        data: 'modalidad',
        className: 'text-start'
      },
      {
        data: 'enfoque',
        className: 'text-start'
      },
      {
        data: 'id',
        className: 'text-center',
        sortable: false,
        render: function (data, type, all, meta) {
          return `
                    <div class="d-flex justify-content-center">

                      <a href="#" class="deleteBtn btn btn-dark shadow btn-xs sharp me-1"
                      data-idplan="${all.id}"
                      data-bs-placement="top"
                      title="Eliminar registro">
                      <i class="fas fa-trash"></i>
                      </a>

                      <a href="javascript:void(0);" class="btnVerCursos btn btn-info shadow btn-xs sharp"
                      data-idplan="${all.id}"
                            data-bs-placement="top"
                            title="Ver Cursos">
                            <i class="fas fa-eye fa-lg"></i>
                            </a>

                    </div>

                  `
        }
      }
    ],
    // rowsGroup: [
    //   'primero:name',
    // ],
    // orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna

  })


  // INICIO - MODAL UPDATE
  $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
    //cambiar el text del titulo
    document.getElementById("text_titulo_card").innerHTML = "Actualizar datos del Plan seleccionado";
    // setear data de programa
    document.getElementById("text_nombreplan").value = $(this).attr("data-nombreplan");
    $("#cb_programa").selectpicker("val", $(this).attr("data-program_id"));
    $("#cb_tipoplan").selectpicker("val", $(this).attr("data-tipo"));
    $("#cb_modalidad").selectpicker("val", $(this).attr("data-modalidad"));
    $("#cb_enfoque").selectpicker("val", $(this).attr("data-enfoque"));
  });
  // FIN - MODAL UPDATE


  // INICIO - MODAL DELETE
  $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
    var id = $(this).data("idplan");
    // confirmacion
    confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el plan, periodos y cursos de la base de datos", "warning")
      .then(function (isConfirm) {
        if (isConfirm.value) {
          // enviando el parametro de la data que se procede a delete
          destroy(id);
        } else {
          console.log("Cancelado");
        }
      });
  });

  function destroy(id) {
    $.ajax({
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: "DELETE",
      url: '/admin/planes_estudio/planes/destroy/' + id,
      beforeSend: function () { },
      success: function (data) {
        if (data.status == true) {
          notificaciontoast("info", data.mensaje, "Éxito!");
          table.ajax.reload();
        } else {
          notificaciontoast("error", data.mensaje, "Error!");
        }
      },
      error: function (error) {
        console.log("Error", error);
      },
    });
  }


  function cbprograma_read() {
    $.ajax({
      type: "GET",
      url: route_ajax_cb_programas,
      dataType: 'json',
      success: function (response) {
        $("#cb_programa").find("option").remove().end() // Agregado
        $("#cb_programa").append('<option disabled selected value="0">Seleccione opción</option>');
        response.forEach((elemento) => {
          $("#cb_programa").append('<option value="' + elemento.id + '" >' + elemento.nombre + ' - Nivel formativo: ' + elemento.nivel_formativo + '</option>');
          $("#cb_programa_name option:last").data('nombre', elemento.nombre);
          $("#cb_programa option:last").data('nivel_formativo', elemento.nivel_formativo);
        });
        $("#cb_programa").selectpicker("refresh");

      }
    });
    var nivelSeleccionado = "";
    $("#cb_programa").on('change', function () {
      nivelSeleccionado = $(this).find('option:selected').data('nivel_formativo');
      window.nivelSeleccionado = nivelSeleccionado;
      // notificaciontoast('info', window.nivelSeleccionado, 'Nivel formativo');
      // console.log(window.nivelSeleccionado)
    });

  }

  cbprograma_read();

  window.table = table;

  // Función para convertir números a números romanos
  function toRoman(num) {
    if (typeof num !== 'number' || num < 1 || num > 3999) {
      return false;
    }

    var digits = String(+num).split(''),
      key = ['', 'C', 'CC', 'CCC', 'CD', 'D', 'DC', 'DCC', 'DCCC', 'CM',
        '', 'X', 'XX', 'XXX', 'XL', 'L', 'LX', 'LXX', 'LXXX', 'XC',
        '', 'I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII', 'IX'],
      roman = '',
      i = 3;

    while (i--) {
      roman = (key[+digits.pop() + (i * 10)] || '') + roman;
    }

    return Array(+digits.join('') + 1).join('M') + roman;
  }
  // LISTAR DATATABLE
  var table2 = $('#datatableGeneral2').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass("selected");
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/admin/institucion/planes/list_by_idplan',
      data: function (d) {
        d.id = dt_idplan;
      },
    },
    searching: false,
    paging: true, // Deshabilita la paginación
    info: false, // Oculta la información de entradas
    pageLength: 12, // 12 filas
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    columns: [
      { data: 'id', className: 'text-center' },
      {
        data: 'periodo',
        className: 'text-center',
        render: function (data, type, all, row) {
          if (all.periodo == 0) {
            // return all.periodo;
            return 'NO'
          } else {
            // Utiliza la función toRoman para convertir el número a número romano
            return type === 'display' ? toRoman(data) : data;
          }
        }
      },
      { data: 'curso', className: 'text-center' },
      { data: 'tipo', className: 'text-center' },
      { data: 'creditos', className: 'text-center' },
      { data: 'horas', className: 'text-center' },
      {
        data: 'id',
        className: 'text-center',
        sortable: false,
        render: function (data, type, all, meta) {
          return `
                    <div class="d-flex justify-content-center">
                      <a href="javascript:void(0);" class="btnEdithCourse btn btn-dark shadow btn-xs sharp"
                      data-idcourse="${all.id}"
                      data-curso="${all.curso}"
                      data-tipocurso="${all.tipo}"
                      data-creditos="${all.creditos}"
                      data-horas="${all.horas}"
                      data-bs-placement="top"
                      title="Editar Curso">
                      <i class="fas fa-pencil-alt"></i>
                      </a>
                    </div>

                  `
        }
      }
    ],
    "rowCallback": function (row, data) {
      // Asignar ID a cada fila
      $(row).attr('id', 'fila_' + data.id); // Supongamos que 'id' es el identificador de tus datos
    }
  });

  // Agregar una columna de números automáticos
  table2.on('order.dt search.dt', function () {
    table2.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
      cell.innerHTML = i + 1;
    });
  }).draw();

  // INICIO - MODAL VER CURSOS
  $("#datatableGeneral tbody").on("click", ".btnVerCursos", function (e) {
    dt_idplan = $(this).data("idplan");
    // cargar tabla
    table2.ajax.reload();
    setTimeout(function () { $("#modalDetalleCursos").modal("show"); }, 500); // mostrar despues de x sec
    // mostrar modal
  });
  // FIN - MODAL VER CURSOS




  //EDITAR CURSO
  $("#datatableGeneral2 tbody").on("click", ".btnEdithCourse", function (e) {
    let formCheck = $("#formModal3")[0];
    $(formCheck).removeClass("was-validated"); // remover validaciones
    $("#formModal3")[0].reset();
    $("#txt_idcourse").val("");
    // cargar tabla
    $("#txt_idcourse").val($(this).data("idcourse"));
    $("#txt_curso").val($(this).data("curso"));
    $("#txt_tipo_curso").val($(this).data("tipocurso"));
    $("#txt_creditos").val($(this).data("creditos"));
    $("#txt_horas").val($(this).data("horas"));

    setTimeout(function () { $("#modalEdithCourse").modal("show"); }, 500); // mostrar despues de x sec
    // mostrar modal
  });
  //FIN


  //BTN ACTUALIZAR CURSO

  $("#btnUpdateCurse").on("click", function (event) {
    event.preventDefault();
    let formCheck = $('#formModal3')[0];
    if (!formCheck.checkValidity()) {
      event.preventDefault();
      event.stopPropagation();

    } else {
      confirmation_sweetAlert("Deseas continuar?", "Se procederá a actualizar la información del curso seleccionado", "warning")
        .then(function (isConfirm) {
          if (isConfirm.value) {
            let idcourse = $("#txt_idcourse").val();
            $.ajax({
              headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
              type: "PUT",
              url: "/admin/institucion/planes/update/course/" + idcourse,
              data: $("#formModal3").serialize(),
              dataType: "json",
              beforeSend: function () {
                notificaciontoast("warning", "Validando información!", "Mensaje!");
              },
              success: function (response) {
                $("#modalEdithCourse").modal("hide");

                if (response.status == true) {
                  notificaciontoast("info", response.mensaje, "Éxitos!");
                  table2.ajax.reload();
                  // document.getElementById("tr37").style.backgroundColor = "blue";
                } else if (response.status == false) {
                  notificaciontoast("error", response.mensaje, "Error!");
                }

              },
              error: function (error) {
                notificaciontoast("error", error, "Error!");
              },
            });

          } else {
            console.log("Cancelado");
          }
        });

    }
    $(formCheck).addClass('was-validated'); // añadir validaciones

  });
  //FIN

})

/**

 php artisan tinker
 User::create(['tipoidenti'=>'DNI','nroidenti'=>'73752966','nombres'=>'Henry','apellido_pa'=>'Torero','apellido_ma'=>'Ramirez','correo'=>'henry@gmail.com','estado'=>'1','ubigeo_id'=>'010101','genre_id'=>'1','usertype_id'=>'1','password'=>Bcrypt('123456')])

 *
 */
