//"use strict";
import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {
    const tableName = "General de Horarios";

    //LISTAR DATATABLE
    var dt_idsemester = 0, dt_idsubject =  0, dt_idclass = 0;

    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        pageLength: 16,
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: 'POST',
            url: '/alumno/asistencias/list_attendances',
            data: function (d) {
                d.idsemester = dt_idsemester,
                d.idsubject = dt_idsubject
            }
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de Horarios " + semester
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "clase", className: "text-center bg-primary", },
            { data: "fecha", className: "text-center bg-primary", },
            { data: "estado", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.estado == 0) {
                        return `<span class="badge light badge-dark">Sin evaluar</span>`;
                    } else if (all.estado == 1) {
                        return `<span class="badge light badge-success">Asistió</span>`;
                    } else if (all.estado == 2) {
                        return `<span class="badge light badge-warning">Tardanza</span>`;
                    } else if (all.estado == 3) {
                        return `<span class="badge light badge-danger">No Asistió</span>`;
                    }
                },
            },
        ],
        // rowsGroup: [
        //     'primero:name',
        // ],
        // orderFixed: [0, 'asc'],
    });


    //--------- F U N C I O N E S --------------//
    // tl_subjects();
    function tl_subjects() {
        $.ajax({
            type: "GET",
            url: '/ajax_all/students/subjects/'+dt_idsemester,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    document.getElementById("tlsubject").innerHTML +=
                        "<li class=''>" +
                        "<div class='divsubject timeline-badge primary'></div>" +
                        "<a class='btnSubject timeline-panel text-muted px-2 py-1 mr-4 ml-2' href='javascript:void(0);' " +
                            "data-idsubject='" + elemento.idsubject + "'" +
                            "data-codcurso='" + elemento.codcurso + "'" +
                            "data-curso='" + elemento.curso + "'" +
                            "data-seccion='" + elemento.seccion + "'" + ">" +
                            "<h6 class='mb-0'>" + "<strong class='text-info'>" + elemento.curso +
                            " - sec: " + elemento.seccion + "</strong>" +
                            "<br>" + elemento.curso  + "</h6>" +
                        "</a>" +
                        "</li>"
                });
            },
            error: function (error) { console.log("Error", error);  },
        });
    }

    // on change semestres
    $(document).on("click", ".btnSemester", function () {
        dt_idsemester = $(this).attr("data-idsemester");
        $(".divsemester").removeClass("warning").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("warning");
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        tl_subjects();
        table.ajax.reload();
    });


    // on change asignaturas
    $(document).on("click", ".btnSubject", function () {
        dt_idsubject = $(this).attr("data-idsubject");
        $(".divsubject").removeClass("success").addClass("primary");
        $(this).prev("div").removeClass("primary").addClass("success");
        notificaciontoast("info", "Consultando a la  base de datos!", "Mensaje!");
        // limpiar tabla
        table.ajax.reload();
    });

});
