//"use strict";
import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {
    const tableName = "General de Horarios ";
    var dt_idsemester = "null",
        semester = "";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: "/alumno/horarios/list_horario",
            data: function (d) {
                d.idsemester = dt_idsemester;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de Horarios " + semester
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
                // customize: function (xlsx) {
                //     var sheet = xlsx.xl.worksheets["sheet1.xml"];

                //     // Establecer el ancho de las columnas si es necesario
                //     var columnStyles = {
                //         A: { width: 10, style: 25 },
                //         B: { width: 30, style: 25 },
                //         C: { width: 8, style: 25 },
                //         D: { width: 8, style: 25 },
                //         E: { width: 8, style: 25 },
                //         F: { width: 8, style: 25 },
                //         G: { width: 8, style: 25 },
                //         H: { width: 15, style: 25 },
                //         I: { width: 15, style: 25 },
                //         J: { width: 15, style: 25 },
                //         K: { width: 15, style: 25 },
                //         L: { width: 15, style: 25 },
                //         M: { width: 15, style: 25 },
                //         N: { width: 30, style: 25 },
                //         O: { width: 8, style: 25 },
                //     };

                //     for (var col in columnStyles) {
                //         var style = columnStyles[col];
                //         $('row c[r^="' + col + '"]', sheet).attr(
                //             "s",
                //             style.style
                //         );
                //         $('col[r="' + col + '"]', sheet).attr(
                //             "width",
                //             style.width
                //         );
                //     }

                //     var rowCount = 0;
                //     $("row c", sheet).each(function () {
                //         var row = this;
                //         if (rowCount == 0) {
                //             $('c[r="A1"]', sheet).attr("s", "51");
                //         }
                //         // Centrar el titulo

                //         var cellValue = $(this).text();

                //         // Verifica si el valor de la celda es "Lunes" y aplica un estilo de fondo.
                //         if (
                //             cellValue === "CodCurso" ||
                //             cellValue === "Nombre del curso" ||
                //             cellValue === "Turno" ||
                //             cellValue === "Seccion" ||
                //             cellValue === "Creditos" ||
                //             cellValue === "Horas" ||
                //             cellValue === "Periodo" ||
                //             cellValue === "Docente" ||
                //             cellValue === "Aula"
                //         ) {
                //             $(this).attr("s", "47"); // Aplica un estilo con fondo de color.
                //         } else if (
                //             cellValue === "Lunes" ||
                //             cellValue === "Martes" ||
                //             cellValue === "Miercoles" ||
                //             cellValue === "Jueves" ||
                //             cellValue === "Viernes" ||
                //             cellValue === "Sabado"
                //         ) {
                //             $(this).attr("s", "42");
                //         } else {
                //             // $(this).attr('s', '25');
                //         }
                //     });
                // },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "codcurso", className: "text-center bg-primary", },
            { data: "curso", className: "text-center bg-primary", },
            { data: "tipo", className: "text-center bg-primary", },
            { data: "condicion", className: "text-center bg-primary", },
            { data: "turno", className: "text-center bg-primary", },
            { data: "seccion", className: "text-center bg-primary", },
            { data: "periodo", className: "text-center bg-primary", },
            { data: "Lunes", className: "text-center bg-info", },
            { data: "Martes", className: "text-center bg-info", },
            { data: "Miercoles", className: "text-center bg-info", },
            { data: "Jueves", className: "text-center bg-info", },
            { data: "Viernes", className: "text-center bg-info", },
            { data: "Sabado", className: "text-center bg-info", },
            { data: "docente", className: "text-center bg-primary", },
            { data: "aula", className: "text-center bg-primary", },
        ],
    });


    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semestersStudent',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semestre").append('<option selected disabled value="">Seleccione semestre  </option>');
                response.forEach((elemento) => {
                    $("#txt-semestre").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    var selectedOption;
    $("#txt-semestre").on('change', function () {

        toastr.info("Consultando en la base de datos ....", "Mensaje", {
            positionClass: "toast-bottom-right", timeOut: 2000, closeButton: !0, debug: !1, newestOnTop: !0, progressBar: !0, preventDuplicates: !0, onclick: null, showDuration: "300", hideDuration: "1000", extendedTimeOut: "1000", showEasing: "swing", hideEasing: "linear", showMethod: "fadeIn", hideMethod: "fadeOut", tapToDismiss: !1
        });

        dt_idsemester = $(this).val();
        selectedOption = $(this).find('option:selected');
        $("#txt-fecinicio").html(selectedOption.data('fecinicio'));
        $("#txt-fecfin").html(selectedOption.data('fecfin'));

        table.ajax.reload();
    });


    list_info()
    function list_info() {
        $.ajax({
            type: "GET",
            url: '/alumno/horarios/list_info',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    $('#txt-codprograma').html(elemento.codprograma);
                    $('#txt-programa').html(elemento.programa);
                    $('#txt-nivel_formativo').html(elemento.nivel_formativo);
                    $('#txt-plan').html(elemento.plan);
                    $('#txt-tipo').html(elemento.tipo);
                    $('#txt-modalidad_enfoque').html(elemento.modalidad + "-" + elemento.enfoque);
                    // $('#txt-semestre').html(elemento.semestre);
                    // $('#txt-fecinicio').html(elemento.fecinicio);
                    // $('#txt-fecfin').html(elemento.fecfin);
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

});
