//"use strict";
import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {
    const tableName = "General de Horarios ";
    var dt_idsemester = "null", dt_idsubject = "null",
        semester = "";

    // LISTAR DATATABLE
    var table = $("#datatableGeneral").DataTable({
            createdRow: function (row, data, index) {
                $(row).addClass("selected");
            },
            order: [],
            ajax: {
                headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
                type: "POST",
                url: "/alumno/horarios/list_nota",
                data: function (d) {
                    d.idsemester = dt_idsemester;
                },
            },
            searching: true,
            dom: "Bfrtip",
            select: false,
            lengthChange: false,
            responsive: true,
            language: {
                search: 'Buscar',
                info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
                zeroRecords: 'No hay registros para mostrar.',
                infoFiltered: '(Filtrados de _MAX_ Registros)',
                emptyTable: 'La tabla está vacia.',
                infoEmpty: 'No hay registros',
                paginate: {
                    next: '<i class="fa-solid fa-angle-right"></i>',
                    previous: '<i class="fa-solid fa-angle-left"></i>'
                }
            },
            buttons: [
                {
                    extend: "excel",
                    title: function () {
                        return (
                            "Reporte de Horarios " + semester
                        );
                    },
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                    // customize: function (xlsx) {
                    //     var sheet = xlsx.xl.worksheets["sheet1.xml"];

                    //     // Establecer el ancho de las columnas si es necesario
                    //     var columnStyles = {
                    //         A: { width: 10, style: 25 },
                    //         B: { width: 30, style: 25 },
                    //         C: { width: 8, style: 25 },
                    //         D: { width: 8, style: 25 },
                    //         E: { width: 8, style: 25 },
                    //         F: { width: 8, style: 25 },
                    //         G: { width: 8, style: 25 },
                    //         H: { width: 15, style: 25 },
                    //         I: { width: 15, style: 25 },
                    //         J: { width: 15, style: 25 },
                    //         K: { width: 15, style: 25 },
                    //         L: { width: 15, style: 25 },
                    //         M: { width: 15, style: 25 },
                    //         N: { width: 30, style: 25 },
                    //         O: { width: 8, style: 25 },
                    //     };

                    //     for (var col in columnStyles) {
                    //         var style = columnStyles[col];
                    //         $('row c[r^="' + col + '"]', sheet).attr(
                    //             "s",
                    //             style.style
                    //         );
                    //         $('col[r="' + col + '"]', sheet).attr(
                    //             "width",
                    //             style.width
                    //         );
                    //     }

                    //     var rowCount = 0;
                    //     $("row c", sheet).each(function () {
                    //         var row = this;
                    //         if (rowCount == 0) {
                    //             $('c[r="A1"]', sheet).attr("s", "51");
                    //         }
                    //         // Centrar el titulo

                    //         var cellValue = $(this).text();

                    //         // Verifica si el valor de la celda es "Lunes" y aplica un estilo de fondo.
                    //         if (
                    //             cellValue === "CodCurso" ||
                    //             cellValue === "Nombre del curso" ||
                    //             cellValue === "Turno" ||
                    //             cellValue === "Seccion" ||
                    //             cellValue === "Creditos" ||
                    //             cellValue === "Horas" ||
                    //             cellValue === "Periodo" ||
                    //             cellValue === "Docente" ||
                    //             cellValue === "Aula"
                    //         ) {
                    //             $(this).attr("s", "47"); // Aplica un estilo con fondo de color.
                    //         } else if (
                    //             cellValue === "Lunes" ||
                    //             cellValue === "Martes" ||
                    //             cellValue === "Miercoles" ||
                    //             cellValue === "Jueves" ||
                    //             cellValue === "Viernes" ||
                    //             cellValue === "Sabado"
                    //         ) {
                    //             $(this).attr("s", "42");
                    //         } else {
                    //             // $(this).attr('s', '25');
                    //         }
                    //     });
                    // },
                },
                {
                    extend: "pdf",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded ",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
                {
                    extend: "print",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
                {
                    extend: "colvis",
                    text: "Seleccionar celdas",
                    title: "Reporte de " + tableName,
                    type: "button",
                    orientation: "landscape",
                    className: "btn btn-sm btn-arounded",
                    exportOptions: {
                        columns: ":visible",
                        orthogonal: "print",
                    },
                },
            ],
            columns: [
                { data: "plan", className: "text-center bg-info", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5 class="badge light badge-info">` + all.plan + `</h5>`
                    },
                },
                { data: "periodo", className: "text-center bg-info", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.periodo + `</h5>`
                    },
                },
                { data: "codcurso", className: "text-center bg-primary", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.codcurso + `</h5>`
                    },
                },
                { data: "curso", className: "text-center bg-primary", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.curso + `</h5>`
                    },
                },
                { data: "creditos_horas", className: "text-center bg-primary", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.creditos_horas + `</h5>`
                    },
                },
                { data: "condicion", className: "text-center bg-primary", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.condicion + `</h5>`
                    },
                },
                { data: "seccion", className: "text-center bg-primary", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.seccion + `</h5>`
                    },
                },
                { data: "turno", className: "text-center bg-primary", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.turno + `</h5>`
                    },
                },
                { data: "idstudent", sortable: false, className: "text-center",
                    render: function (data, type, all, meta) {
                        return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btnViewEvaluations btn btn-success shadow btn-xs sharp"
                                data-idstudent="${all.idstudent}"
                                data-idsubject="${all.idsubject}"
                                data-bs-placement="top"
                                title="Ver Evaluaciones">
                                <i class="fa-solid fa-eye fa-fade fa-xl"></i>
                            </a>
                        </div>
                        `;
                    },
                },
                { data: "promedio_final", className: "text-center bg-dark", sortable: false,
                    render: function (data, type, all, meta) {
                            return `<h5>` + all.promedio_final + `</h5>`
                    },
                },
                { data: "promedio_final", className: "text-center bg-dark", sortable: false,
                    render: function (data, type, all, meta) {
                        if (all.promedio_final == 0) {
                            return `<span class="badge light badge-dark">Sin Evaluar</span>`;
                        }
                        else if (all.promedio_final < 12.5) {
                            return `<span class="badge light badge-danger">Desaprobado</span>`;
                        } else if (all.promedio_final > 12.5){
                            return `<span class="badge light badge-success">Aprobado</span>`;
                        }
                    },
                }
            ],
        });

    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semestersStudent',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semestre").append('<option selected disabled value="">Seleccione semestre  </option>');
                response.forEach((elemento) => {
                    $("#txt-semestre").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    var selectedOption;
    $("#txt-semestre").on('change', function () {

        toastr.info("Consultando en la base de datos ....", "Mensaje", {
            positionClass: "toast-bottom-right", timeOut: 2000, closeButton: !0, debug: !1, newestOnTop: !0, progressBar: !0, preventDuplicates: !0, onclick: null, showDuration: "300", hideDuration: "1000", extendedTimeOut: "1000", showEasing: "swing", hideEasing: "linear", showMethod: "fadeIn", hideMethod: "fadeOut", tapToDismiss: !1
        });

        dt_idsemester = $(this).val();
        selectedOption = $(this).find('option:selected');
        $("#txt-fecinicio").html(selectedOption.data('fecinicio'));
        $("#txt-fecfin").html(selectedOption.data('fecfin'));

        table.ajax.reload();
    });


    list_info()
    function list_info() {
        $.ajax({
            type: "GET",
            url: '/alumno/horarios/list_info',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                response.forEach((elemento) => {
                    $('#txt-codprograma').html(elemento.codprograma);
                    $('#txt-programa').html(elemento.programa);
                    $('#txt-nivel_formativo').html(elemento.nivel_formativo);
                    $('#txt-plan').html(elemento.plan);
                    $('#txt-tipo').html(elemento.tipo);
                    $('#txt-modalidad_enfoque').html(elemento.modalidad + "-" + elemento.enfoque);
                    // $('#txt-semestre').html(elemento.semestre);
                    // $('#txt-fecinicio').html(elemento.fecinicio);
                    // $('#txt-fecfin').html(elemento.fecfin);
                });
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }




     // INICIO - MODAL VER CURSOS
     $("#datatableGeneral tbody").on("click", ".btnViewEvaluations", function (e) {
        dt_idsubject = $(this).data("idsubject");
        document.getElementById("modalDetalleNotasLabel").innerHTML = "Detalle notas del alumno: " + $(this).data("estudiante")
        // cargar tabla
        table_evaluations.ajax.reload();
        setTimeout(function () { $("#modalDetalleNotas").modal("show"); }, 500); // mostrar despues de x sec
        // mostrar modal
    });
    // FIN - MODAL VER CURSOS


    // LISTAR DATATABLE 2
    var table_evaluations = $('#datatableGeneralEvaluaciones').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/alumno/notas/list_detalle_nota',
            data: function (d) {
                d.idsubject = dt_idsubject;
            },
        },
        searching: false,
        paging: false, // Deshabilita la paginación
        info: false, // Oculta la información de entradas
        pageLength: 12, // 12 filas
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        columns: [
            { data: 'idstudent', className: 'text-center' },
            { data: 'tipo_nota', className: 'text-center', name: 'primero' },
            // { data: 'porcentaje', className: 'text-center' },
            { data: "porcentaje", sortable: false, className: "text-center", name: 'segundo',
                render: function (data, type, all, meta) {
                    return `
                    <div class="d-flex justify-content-center">
                        ${all.porcentaje*100}%
                    </div>
                    `;
                },
            },
            { data: 'nombre_evento', className: 'text-center' },
            { data: 'fecinicio', className: 'text-center' },
            { data: 'nota', className: 'text-center' },
        ],
        rowsGroup: [
            'primero:name',
            'segundo:name',
        ],
    });


    // Agregar una columna de números automáticos
    table_evaluations.on('order.dt search.dt', function () {
        table_evaluations.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();
});
