import { notificaciontoast } from '../jsAjaxToastSweetalert/method_toast.js'
import { confirmation_sweetAlert } from '../jsAjaxToastSweetalert/method_sweetAlert.js'
$(document).ready(function () {

  // JAVASCRIPT EVENTOS PENDIENTES
  const tableName01 = 'Programacion pendiente'

  var table = $('#datatableGeneralPendientes').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: '/alumno/programacion/ajax_all/eventos/pendientes',
    pageLength: 12, // 12 filas
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: 'Reporte de ' + tableName01,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName01,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName01,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        txt: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName01,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      {data: 'namecurso',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<h5><strong>' + all.namecurso + '</strong></h5>' +
            "<p style='font-size:14px' class='text-danger m-0'><strong> Docente:</strong> " + all.namecurso + '<strong>' +
            "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + '<strong> Turno:</strong> ' + all.turno + '<br>' +
            '<strong>Fecha: </strong>' + all.fecha + ' <br>' +
            '<strong>Hora: </strong>' + all.horario + ' </p>'
      }},
      { data: 'tipo_programacion', className: 'text-start' },
      { data: 'nombre_evento', className: 'text-start' },
      { data: 'descripcion', className: 'text-start' }
    ]
  })
  // FIN

  // JAVASCRIPT EVENTOS ASIGNADOS
  const tableName02 = 'Programacion Asignada'

  var table2 = $('#datatableGeneralAsginados').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: '/alumno/programacion/ajax_all/eventos/asignados',
    pageLength: 12, // 12 filas
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: 'Reporte de ' + tableName02,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName02,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName02,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        txt: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName02,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      {data: 'namecurso',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<h5><strong>' + all.namecurso + '</strong></h5>' +
            "<p style='font-size:14px' class='text-danger m-0'><strong> Docente:</strong> " + all.namedocente + '<strong>' +
            "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + '<strong> Turno:</strong> ' + all.turno + '<br>' +
            '<strong>Fecha: </strong>' + all.fecha + ' <br>' +
            '<strong>Hora: </strong>' + all.horario + ' </p>'
        }
      },
      { data: 'tipo_programacion', className: 'text-start' },
      { data: 'nombre_evento', className: 'text-start' },
      { data: 'descripcion', className: 'text-start' },
      {data: 'horaini',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<strong>Desde: </strong>' + all.horaini + ' <br>' +
            '<strong>Hasta: </strong>' + all.horafin + ' </p>'
        }
      },
      { data: 'tiempoduracion', className: 'text-center' },
      {
        data: 'archivo',
        sortable: false,
        className: 'text-center',

        render: function (data, type, all, meta) {
          if (all.archivo != '-' ) {
            return `<a href="/alumno/programacion/asignada/viewfile/${all.dnidocente}/${all.id}/${all.codcurso}/${all.archivo}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`
          }else {
            return `No asignado`
          }
        }
      },
      {
        data: 'archivosubido',
        sortable: false,
        className: 'text-center',

        render: function (data, type, all, meta) {
          if (all.archivosubido !=  null) {
            return `<a href="/alumno/programacion/asignada/viewfile/upload/${all.dnidocente}/${all.id}/${all.codcurso}/${all.archivosubido}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`
          }else {
            return `No asignado`
          }
        }
      },
      {data: 'estadoevento',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
            if (all.estadoevento == 'Entregado') {
            return `<span class="badge light badge-success">${all.estadoevento}</span>`
            }else {
            return `<span class="badge light badge-danger">${all.estadoevento}</span>`
            }
        }
        },
      {
        data: 'id',
        className: 'text-center noExport', sortable: false, searchable: false,
        render: function (data, type, all, meta) {
            if (all.estadoevento == 'Entregado') {
                return `<div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="restricBtn btn btn-primary shadow btn-xs sharp  me-1"
                            data-bs-placement="top"
                            title="Restringido">
                            <i class="fas fa-ban"></i>
                            </a>
                     </div>`
              }else {
                return `<div class="d-flex justify-content-center">
                    <a href="javascript:void(0);" class="uploadBtn btn btn-info shadow btn-xs sharp  me-1"
                    data-bs-placement="top"
                    data-idasigcalendar = "${all.id}"
                    data-idasigpro = "${all.idasigpro}"
                    data-dnidocente = "${all.dnidocente}"
                    data-codcurso = "${all.codcurso}"
                    data-idstudent = "${all.idalumno}"
                    title="Cargar archivo">
                    <i class="fas fa-upload"></i>
                    </a>
                </div>`
              }
        }
      }
    ]
  });

  $('#datatableGeneralAsginados tbody').on('click', '.restricBtn', function (e) {
    event.preventDefault()
    Swal.fire({
        title: "Alerta!",
        text: "Usted ya cargo su archivo, no insistir",
        type: "warning",
        width: 600,
        padding: "3em",
        color: "#716add",
        background: "#fff url(/images/trees.png)",
        backdrop: `
        rgba(4, 27, 11, 0.796)
          url("/images/nyan-cat.gif")
          left top
          no-repeat
        `
      });


  })

  $('#datatableGeneralAsginados tbody').on('click', '.uploadBtn', function (e) {
    event.preventDefault()
    document.getElementById('formModalAsignarfileevento').classList.remove('was-validated')
    document.getElementById('formModalAsignarfileevento').reset()
    $('#id_evento_asig_calendar').val($(this).data('idasigcalendar'))
    $('#id_evento_asig_program').val($(this).data('idasigpro'))
    $('#txt_data_cod_curso').val($(this).data('codcurso'))
    $('#data_dnidocente').val($(this).data('dnidocente'))
    $('#data_id_user').val($(this).data('idstudent'))

    $('#modalAsignarfileevento').modal('show')
  })

  var estado = false
  $('#btnSaveprogramacion').on('click', function (event) {
    event.preventDefault()
    let formCheck = $('#formModalAsignarfileevento')[0]
    if (!formCheck.checkValidity()) {
      event.preventDefault()
      event.stopPropagation()
    } else {
      confirmation_sweetAlert('Deseas continuar?', 'Se procederá a activar el evento, con la información ', 'warning')
        .then(function (isConfirm) {
          if (isConfirm.value) {
            // FUNCION REGISTRAR TRAMITE
            if (estado === true) {
              document.getElementById('formModalAsignarfileevento').classList.remove('was-validated')
              document.getElementById('file_solucionPrueba').classList.remove('is-invalid')
              estado = false
            }
            var formData = new FormData(document.getElementById('formModalAsignarfileevento'))
            $.ajax({
              headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
              type: 'POST',
              url: '/alumno/programacion/asignada/cargar/file/evento',
              data: formData,
              processData: false,
              contentType: false,
              beforeSend: function () {
                notificaciontoast('warning', 'Validando información!', 'Mensaje!')
              },
              success: function (response) {
                if (response.status == true) {
                  notificaciontoast('info', response.mensaje, 'Éxitos!')
                  document.getElementById('formModalAsignarfileevento').classList.remove('was-validated')
                  document.getElementById('formModalAsignarfileevento').reset()
                  $('#id_evento_asig_calendar').val('')
                  $('#id_evento_asig_program').val('')
                    $('#txt_data_cod_curso').val('')
                    $('#data_dnidocente').val('')
                    $('#data_id_user').val('')

                  table2.ajax.reload()
                  $('#modalAsignarfileevento').modal('hide')
                } else if (response.status == false) {
                  if (typeof response.mensaje.file_solucionPrueba != 'undefined') {
                    document.getElementById('file_solucionPrueba').classList.add('is-invalid')
                    document.getElementById('validate_message_File_docuemento').innerHTML = response.mensaje.file_solucionPrueba[0]
                  }
                  estado = true
                }
              },
              error: function (error) {
                notificaciontoast('error', error, 'Error!')
              }
            })
          } else {
            console.log('Cancelado')
          }
        })
    }
    $(formCheck).addClass('was-validated'); // añadir validaciones

  })
  // FIN

  // JAVASCRIPT EVENTOS FINALIZAD
  const tableName03 = 'Programacion Asignada'
  var table3 = $('#datatableGeneralEvntfianlizado').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: '/alumnos/programacion/ajax_all/eventos/finalizados',
    pageLength: 12, // 12 filas
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: 'Reporte de ' + tableName03,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName03,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName03,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        txt: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName03,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      {data: 'namecurso',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<h5><strong>' + all.codcurso + ' - ' + all.namecurso + '</strong></h5>' +
            "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + '<strong> Turno:</strong> ' + all.turno + '<br>' +
            '<strong>Fecha: </strong>' + all.fecha + ' <br>' +
            '<strong>Hora: </strong>' + all.horario + ' </p>'
        }
      },
      { data: 'tipo_programacion', className: 'text-start' },
      { data: 'nombre_evento', className: 'text-start' },
      { data: 'descripcion', className: 'text-start' },
      {data: 'horaini',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<strong>Desde: </strong>' + all.horaini + ' <br>' +
            '<strong>Hasta: </strong>' + all.horafin + ' </p>'
        }
      },
      { data: 'horaextend', className: 'text-center' },
      { data: 'tiempoduracion', className: 'text-center' },
      {
        data: 'archivo',
        sortable: false,
        className: 'text-center',

        render: function (data, type, all, meta) {
          if (all.archivo != '-' ) {
            return `<a href="/alumno/programacion/asignada/viewfile/${all.dnidocente}/${all.id}/${all.codcurso}/${all.archivo}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`
          }else {
            return `No asignado`
          }
        }
      },
      {
        data: 'archivosubido',
        sortable: false,
        className: 'text-center',

        render: function (data, type, all, meta) {
          if (all.archivosubido !=  null) {
            return `<a href="/alumno/programacion/asignada/viewfile/upload/${all.dnidocente}/${all.id}/${all.codcurso}/${all.archivosubido}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`
          }else {
            return `No asignado`
          }
        }
      },
      {data: 'estadoevento',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          if (all.estadoevento == 'Entregado') {
            return `<span class="badge light badge-success">${all.estadoevento}</span>`
          }else {
            return `<span class="badge light badge-danger">${all.estadoevento}</span>`
          }
        }
      }
    ]
  })
  // FIN

  // JAVASCRIPT EVENTOS EVALUADOS
  const tableName04 = 'Programacion de eventos evaluados'

  var table4 = $('#datatableGeneralEvaluados').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: '/alumnos/programacion/ajax_all/eventos/evaluados',
    pageLength: 12, // 12 filas
    searching: true,
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: 'Reporte de ' + tableName04,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName04,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName04,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        txt: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName04,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      {data: 'namecurso',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<h5><strong>' + all.codcurso + ' - ' + all.namecurso + '</strong></h5>' +
            "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + '<strong> Turno:</strong> ' + all.turno + '<br>' +
            '<strong>Fecha: </strong>' + all.fecha + ' <br>' +
            '<strong>Hora: </strong>' + all.horario + ' </p>'
        }
      },
      { data: 'tipo_programacion', className: 'text-start' },
      { data: 'nombre_evento', className: 'text-start' },
      { data: 'descripcion', className: 'text-start' },
      {data: 'horaini',
        className: 'text-start mx-2',

        render: function (data, type, all, meta) {
          return '<strong>Desde: </strong>' + all.horaini + ' <br>' +
            '<strong>Hasta: </strong>' + all.horafin + ' </p>'
        }
      },
      { data: 'horaextend', className: 'text-center' },
      { data: 'tiempoduracion', className: 'text-center' },
      {
        data: 'archivo',
        sortable: false,
        className: 'text-center',

        render: function (data, type, all, meta) {
          if (all.archivo != '-' ) {
            return `<a href="/alumno/programacion/asignada/viewfile/${all.dnidocente}/${all.id}/${all.codcurso}/${all.archivo}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`
          }else {
            return `No asignado`
          }
        }
      },
      {
        data: 'archivosubido',
        sortable: false,
        className: 'text-center',

        render: function (data, type, all, meta) {
          if (all.archivosubido !=  null) {
            return `<a href="/alumno/programacion/asignada/viewfile/upload/${all.dnidocente}/${all.id}/${all.codcurso}/${all.archivosubido}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`
          }else {
            return `No asignado`
          }
        }
      },
      {data: 'estadoevento',
        className: 'text-center mx-2',

        render: function (data, type, all, meta) {
          if (all.estadoevento == 'Evaluado') {
            return `<span class="badge light badge-success">${all.estadoevento}</span>`
          }else {
            return `<span class="badge light badge-danger">${all.estadoevento}</span>`
          }
        }
      },
      { data: 'nota', className: 'text-center' }
    ]
  })
  // FIN


  $('#btn_secTable_home1').on('click', function (e) {
    e.preventDefault();
    table.ajax.reload();
    });
    $('#btn_secTable_profile1').on('click', function (e) {
        e.preventDefault();
        table2.ajax.reload();
    });
    $('#btn_secTable_contact1').on('click', function (e) {
        e.preventDefault();
        table3.ajax.reload();
    });
    $('#btn_secTable_message1').on('click', function (e) {
        e.preventDefault();
        table4.ajax.reload();
    });

})
