import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

document.addEventListener('DOMContentLoaded', function () {

    var idsemester, idsubject, idevaluateprogramming;

    var functionCalendarioprogramacion = function () {
        $.ajax({
            type: "GET",
            url: "/alumno/programacion/ajax_all/eventos/calendario/"+idsemester,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {

                var calendar = new FullCalendar.Calendar(document.getElementById('calendar'), {

                    eventDidMount: function(info) {
                        var title = info.event.extendedProps.namecurso;
                        var description = info.event.extendedProps.description;

                        var tooltipContent = '<div class="tooltip-custom">' +
                                '<div class="tooltip-title">' + title + '</div>' +
                                '<div class="tooltip-description">' + description + '</div>' +
                            '</div>';

                        var tooltip = new bootstrap.Tooltip(info.el, {
                            title: tooltipContent,
                            placement: 'top',
                            trigger: 'hover',
                            container: 'body',
                            html: true
                        });
                    },

                    eventClick: function(info) {
                        console.log(info.event.extendedProps.description);
                    },

                    headerToolbar: {
                        left: 'prev,next today',
                        center: 'title',
                        right: 'dayGridMonth,timeGridWeek,timeGridDay'
                    },
                    locale: 'es',
                    navLinks: false, // can click day/week names to navigate views
                    editable: false,
                    droppable: false, // this allows things to be dropped onto the calendar
                    dayMaxEvents: true,
                    initialView: 'dayGridMonth',
                    initialDate: '2024-01-01',
                    eventColor: 'green',
                    buttonText: {
                        today: 'Hoy',
                        month: 'Mes',
                        week: 'Semana',
                        day: 'Día'
                    },
                    events: response
                });

                calendar.render();
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    };

    // Eventos_programados_asignados();
    function Eventos_programados_asignados(idsubject) {
        $.ajax({
            type: "GET",
            url: "/alumno/programacion/ajax_all/eventos/programados/" + idsubject,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                response.forEach((elemento) => {
                    html += `
                    <li>
                        <div class="timeline-panel">
                            <div class="col-xl-9 col-sm-6">
                                <div class="card schedule-card mb-0">
                                    <div class="card-body px-3 pb-1 pt-1">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <ul class="list-unstyled">
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-solid fa-book fa-lg" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    <b class="text-md text-primary">${elemento.nombre_evento}</b>
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-solid fa-star" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    ${elemento.tipo_nota} - Peso: ${elemento.porcentaje}
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-calendar-days fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    ${elemento.fecha}
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-clock fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    De ${elemento.horaini2} a ${elemento.horafin2}
                                                    
                                                    <a href="/alumno/programacion/evaluaciones/download/${elemento.scheduleingcalendar_id}" target="_blank" class="downloadBtn btn btn-primary shadow btn-xs sharp mx-2"
                                                        data-bs-placement="top"
                                                        title="Descargar Archivo de la Evaluación">
                                                        <i class="fa-solid fa-download fa-lg"></i>
                                                    </a>
                                                </li>
                                                <li class="d-flex align-items-center">
                                                    <b>Nota: ${elemento.nota}</b>
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-3 col-sm-6 d-flex justify-content-center align-items-center">
                                <div class="file-list">
                                    <a href="/alumno/programacion/evaluaciones/viewLoadFile/${elemento.idevaluateprogramming}" target="_blank" class="viewFileBtn btn btn-dark shadow btn-xs sharp me-2"
                                        data-bs-placement="top"
                                        title="Ver Documento">
                                        <i class="fa-solid fa-eye fa-lg"></i>
                                    </a>

                                    <a href="javascript:void(0);" class="loadFileBtn btn btn-success shadow btn-xs sharp me-2"
                                        data-idevaluateprogramming="${elemento.idevaluateprogramming}"
                                        data-scheduleingcalendar_id="${elemento.scheduleingcalendar_id}"
                                        data-subject_id="${elemento.subject_id}"
                                        data-gradetype_id="${elemento.gradetype_id}"
                                        data-nombre_evento="${elemento.nombre_evento}"
                                        data-fecinicio="${elemento.fecinicio}"
                                        data-horaini="${elemento.horaini}"
                                        data-horafin="${elemento.horafin}"
                                        data-duracion="${elemento.duracion}"
                                        data-descripcion="${elemento.descripcion}"
                                        data-estado="${elemento.estado}"
                                        data-tipo_nota="${elemento.tipo_nota}"
                                        data-namecurso="${elemento.namecurso}"
                                        data-bs-placement="top"
                                        title="Enviar Documento">
                                        <i class="fa-solid fa-file-export fa-lg"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </li>`;
                })
                document.getElementById("list_evaluaciones").innerHTML= html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    $(document).on("change", "#txt-semestre", function () {
        idsemester = $(this).val();
        idsubject = "0";
        $("#text_asignatura").val("");
        cb_subjects(idsemester);
        Eventos_programados_asignados(idsubject)
        functionCalendarioprogramacion(idsemester);
    });

    $(document).on("change", "#txt-asignatura", function () {
        idsubject = $(this).val();
        var curso = $('option:selected', this).data('namecurso');
        $("#dt-subject_id").val(idsubject);
        $("#text_asignatura").val(curso);
        Eventos_programados_asignados(idsubject);
    });


    // INICIO - MODAL UPDATE
    $("#list_evaluaciones").on("click", ".loadFileBtn", function () {
        clearForm();
        // setear data de usuario
        $("#dt-idevaluateprogramming").val($(this).data("idevaluateprogramming"));
        $("#dt-scheduleingcalendar_id").val($(this).data("scheduleingcalendar_id"));
        $("#dt-subject_id").val($(this).data("subject_id"));
        $("#dt-nombre_evento").val($(this).data("nombre_evento"));
        $("#dt-archivo").val("");
        // show form
        $("#modalLoadFile").modal("show");
    });
    // FIN - MODAL UPDATE


    var formCheck, valbtn;
    $('#btnLoadFile').on('click', function (event) {
        store();
    });



    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semesters_students',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semestre").append('<option selected disabled value="">Selecciona un semestre</option>');
                response.forEach((elemento) => {
                    $("#txt-semestre").append('<option' +
                        ' value="' + elemento.idsemester + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_subjects(idsemester) {
        $("#txt-asignatura").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: "/alumno/materiales_recursos/list_subjects/" + idsemester,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-asignatura").append('<option selected disabled value="">Selecciona una asignatura</option>');
                response.forEach((elemento) => {
                    $("#txt-asignatura").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-namecurso="' + elemento.namecurso + '" ' +
                        '>' + elemento.namecurso + " - Sec:" + elemento.seccion + '</option>');
                })
                $("#txt-asignatura").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function store() {
        var formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/alumno/programacion/evaluaciones/store',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                if (data.status == true) {
                    notificaciontoast('info', data.mensaje, 'Éxito!')
                    $("#modalLoadFile").modal("hide");
                    functionCalendarioprogramacion(idsemester);
                    Eventos_programados_asignados(idsubject);
                } else {
                    notificaciontoast("error", data.mensaje, "Atención!", "bottom-right", 3000);
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function clearForm() {
        $("#dt-idevaluateprogramming").val("");
        $("#dt-scheduleingcalendar_id").val("");
        $("#dt-nombre_evento").val("");
        $("#dt-archivo").val("");
    }
});


