import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

document.addEventListener('DOMContentLoaded', function () {

    var idsemester, idsubject, idforum;

    function list_forums(idsubject) {
        $.ajax({
            type: "GET",
            url: "/alumno/foros/list/" + idsubject,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                response.forEach((elemento) => {
                    html += `
                    <li>
                        <div class="timeline-panel">
                            <div class="col-xl-11 col-sm-6">
                                <div class="card schedule-card mb-0">
                                    <div class="card-body px-3 pb-1 pt-1">
                                        <div class="d-flex align-items-center justify-content-between">
                                            <ul class="list-unstyled">
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-solid fa-book fa-lg" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    <b class="text-md text-primary">${elemento.titulo}</b>
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-calendar-days fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    Inicio: ${elemento.fecinicio2}
                                                </li>
                                                <li class="mb-2 d-flex align-items-center">
                                                    <i class="fa-regular fa-calendar-days fa-lg mr-2" style="color: #125e47; margin-right: 0.5rem;"></i>
                                                    Fin: ${elemento.fecfin2}
                                                </li>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-xl-1 col-sm-6 d-flex justify-content-center align-items-center">
                                    <a href="javascript:void(0);" class="viewBtn btn btn-primary shadow btn-xs sharp"
                                        data-idforum="${elemento.idforum}"
                                        data-titulo="${elemento.titulo}"
                                        data-descripcion="${elemento.descripcion}"
                                        data-fecinicio="${elemento.fecinicio}"
                                        data-fecfin="${elemento.fecfin}"
                                        data-autor="${elemento.autor}"
                                        data-fecha_mod="${elemento.fecha_mod}"
                                        data-bs-placement="top"
                                        title="Ver Foro">
                                        <i class="fa-solid fa-eye fa-lg"></i>
                                    </a>
                            </div>
                        </div>
                    </li>`;
                })
                document.getElementById("list_foros").innerHTML= html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function list_forum_answers(idforum) {
        $.ajax({
            type: "GET",
            url: "/alumno/respuestas_foros/list/" + idforum,
            dataType: "json",
            beforeSend: function () { },
            success: function (response) {
                var html = "";
                var cont = 1;
                response.forEach((elemento) => {
                    if (cont==1) {
                        html +=`<div class="list-group-item list-group-item-action flex-column align-items-start rounded-0">`;
                    } else {
                        html +=`<div class="list-group-item list-group-item-action flex-column align-items-start">`;
                    }
                    html +=         `<div class="d-flex w-100 justify-content-between">
                                        <h5 class="mb-0">${elemento.estudiante}</h5>
                                        <small>Modificado hace ${elemento.dias_transcurridos} días
                                        </small>
                                    </div>
                                    <div class="d-flex align-items-center">
                                        <textarea class="form-control" rows="2" readonly data-iduser="${elemento.iduser}">${elemento.comentario}</textarea>
                                    `;
                    if( $("#dt-iduser").val() == elemento.iduser)
                        html +=        `<a href="javascript:void(0);" class="editBtn btn btn-dark btn-xs sharp ms-3"
                                            data-idforum="${elemento.idforum}"
                                            data-idforumanswer="${elemento.idforumanswer}"
                                            data-comentario="${elemento.comentario}"
                                            data-bs-placement="top"
                                            title="Editar Respuesta">
                                            <i class="fas fa-pencil-alt"></i>
                                        </a>
                                    </div>
                                </div>`;
                    else {
                        html +=    `</div>
                                </div>`;
                    }    
                    cont++;
                })
                document.getElementById("list_respuestas").innerHTML= html;
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    $(document).on("change", "#txt-semestre", function () {
        idsemester = $(this).val();
        idsubject = "0";
        $("#text_asignatura").val("");
        cb_subjects(idsemester);
        list_forum_answers(0);
        list_forums(idsubject);
        clearTXT();
    });

    $(document).on("change", "#txt-asignatura", function () {
        idsubject = $(this).val();
        var curso = $('option:selected', this).data('namecurso');
        $("#dt-subject_id").val(idsubject);
        $("#text_asignatura").val(curso);
        list_forum_answers(0);
        list_forums(idsubject);
        clearTXT();
    });



    // INICIO - MODAL VIEW
    $("#list_foros").on("click", ".viewBtn", function (e) {
        idforum = $(this).data("idforum");
        $("#txt-autor").html("Autor: " + $(this).data("autor"));
        $("#txt-titulo").html("Titulo del Tema: " + $(this).data("titulo"));
        $("#txt-fecha_mod").html("Ultima modificación: " + $(this).data("fecha_mod"));
        $("#txt-descripcion").val($(this).data("descripcion"));

        list_forum_answers(idforum);
    });
    // FIN - MODAL VIEW

    // INICIO - MODAL CREATE
    $("#btnCreate").click(function () {
        $("#dt-idforum").val(idforum);
        $("#dt-comentario").val( $("#txt-comentario").val() )   
        store();
        $("#txt-comentario").val("");
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#list_respuestas").on("click", ".editBtn", function () {
        // setear data de usuario
        $("#dt-idforumanswer").val($(this).data("idforumanswer"));
        $("#dt-idforum").val($(this).data("idforum"));
        $("#dt-comentario").val($(this).data("comentario"));
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL UPDATE


    var formCheck, valbtn;
    $('#btnUpdate').on('click', function (event) {
        update($("#dt-idforumanswer").val());
        $("#txt-comentario").val("");
    });



    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt-semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semestersStudent',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-semestre").append('<option selected disabled value="">Selecciona un semestre</option>');
                response.forEach((elemento) => {
                    $("#txt-semestre").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt-semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function cb_subjects(idsemester) {
        $("#txt-asignatura").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: "/alumno/materiales_recursos/list_subjects/" + idsemester,
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt-asignatura").append('<option selected disabled value="">Selecciona una asignatura</option>');
                response.forEach((elemento) => {
                    $("#txt-asignatura").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-namecurso="' + elemento.namecurso + '" ' +
                        '>' + elemento.namecurso + " - Sec:" + elemento.seccion + '</option>');
                })
                $("#txt-asignatura").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    var formData;
    function store() {
        var formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/alumno/respuestas_foros/store',
            data: formData,
            processData: false,
            contentType: false,
            success: function (data) {
                // Validators
                if (data.status == 'validators') {
                    for (var campo in data.mensaje) {
                        if (data.mensaje.hasOwnProperty(campo)) {
                            var mensajes = data.mensaje[campo];
                            for (var i = 0; i < mensajes.length; i++) {
                                var mensaje = mensajes[i];
                                // console.log("campo: " + campo + ", mensaje: " + mensaje);
                                notificaciontoast("error", mensaje, "Error!", "bottom-right", 3000);
                            }
                        }
                    }
                }
                if (data.status == true) {
                    notificaciontoast('info', data.mensaje, 'Éxito!')
                    $("#modalCreateUpdate").modal("hide");
                    list_forum_answers(idforum);
                } else if (data.status == false) 
                {
                    notificaciontoast('error', data.mensaje, 'Error!')
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function update(idforumanswer) {
        formData = new FormData(document.getElementById('formModal'));
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/alumno/respuestas_foros/update/' + idforumanswer,
                data: formData,
                processData: false,
                contentType: false,
            success: function (data) {
                if (data.status == true) {
                    // formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                    list_forum_answers(idforum);
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function clearTXT() {
        $("#txt-autor").html("");
        $("#txt-titulo").html("");
        $("#txt-fecha_mod").html("");
        $("#txt-descripcion").val("");
        $("#txt-comentario").val("");
    }

    function clearForm() {
        $("#dt-idforum").val("");
        $("#dt-idforumanswer").val("");
        $("#dt-comentario").val("");
    }

});


