"use strict";

import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {

    $.ajax({
        type: "GET",
        url: '/home/student/dataAsignaturas',
        dataType: 'json',
        success: function (response) {
            if (response.status === true) {
                if (response.data.length > 0) {
                    let html = '';
                    let count = 1;
                    response.data.forEach((e) => {
                        html += `<li>
                                    <div class="timeline-badge info">
                                    </div>
                                    <a class="timeline-panel text-muted" href="#">
                                        <h4 class="mb-0">${e.curso}</h4>
                                        <h6 class="mb-0">Código: <strong class="text-primary">${e.codcurso}</strong> </h6>
                                        <span><strong class="text-info"> Periodo: ${e.periodo} - Créditos: ${e.creditos} </strong></span>
                                        <p class="mb-0">Semestre: ${e.semestre} - Tipo: ${e.tipo}</p>
                                    </a>
                                </li>`;
                                count++;
                    });
                    document.getElementById("total_asign").innerHTML = "Total: "+count;
                    document.getElementById("list_asignaturas").innerHTML = html;
                }
            }
        },
        error: function (error) {
            console.log("Error", error);
        },
    });


    const tableName = "Historial de asignaturas de estudiante";
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            type: 'GET',
            url: '/home/student/list_history_cursos',
        },
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                txt: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "semestre", className: "text-start", name: "primero",
                render: function (data, type, all, meta) {
                    return `<div class="timeline-panel text-muted">
                                <span><strong class="text-info">Semestre: ${all.semestre}</strong></span>
                            </div>`
                },
            },
            { data: "periodo", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return (all.periodo);
                },
            },
            { data: "codcurso", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    return (all.codcurso);
                },
            },
            { data: "curso", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.curso);
                },
            },
            { data: "seccion", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.seccion);
                },
            },
            { data: "turno", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.turno);
                },
            },
            { data: "docente", sortable: false, className: "text-start",
                render: function (data, type, all, meta) {
                    return (all.docente);
                },
            },
            { data: "promedio_final", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.promedio_final == 0) {
                        return `Sin Evaluar`;
                    } else {
                        return (all.promedio_final);
                    }
                },
            },
            { data: "notalumno", sortable: false, className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.promedio_final == 0) {
                        return `<span class="badge light badge-dark">Sin nota</span>`;
                    } else if (all.promedio_final < 12.5) {
                        return `<span class="badge light badge-danger">Desaprobado</span>`;
                    } else if (all.promedio_final >= 12.5) {
                        return `<span class="badge light badge-success">Aprobado</span>`;
                    }
                },
            }
        ],
        rowsGroup: [
            'primero:name',
        ],
        orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna
    });

});

