import { notificaciontoast } from '../jsAjaxToastSweetalert/method_toast.js'
import { confirmation_sweetAlert } from '../jsAjaxToastSweetalert/method_sweetAlert.js'

$(document).ready(function () {
  const tableName = 'Mis Solicitudes'

  var dt_idplanequivalence = '0'
  var formModal, formData

  // LISTAR DATATABLE
  var table = $('#datatableGeneral_pendientes').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/alumno/solicitudes/list/0'
    },
    searching: true,
    pageLength: 12, // 12 filas
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [{
      extend: 'excel',
      title: 'Reporte de ' + tableName,
      type: 'button',
      orientation: 'landscape',
      className: 'btn btn-sm btn-arounded',
      exportOptions: {
        columns: ':visible',
        columns: ':not(.noExport)',
        orthogonal: 'print'
      }
    },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        text: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      { data: 'idtdrequest', className: 'text-center' },
      { data: 'codigo', className: 'text-center' },
      { data: 'tipo', className: 'text-center' },
      { data: 'asunto', className: 'text-center' },
      { data: 'folios', className: 'text-center' },
      // { data: 'ruta_file', className: 'text-center', },
      {
        data: 'ruta_file',
        sortable: false,
        className: 'text-center',
        render: function (data, type, all, meta) {
          if (all.ruta_file == null) {
            return '--'
          } else if (all.ruta_file == '--') {
            return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="btn btn-dark shadow btn-xs sharp disabled"
                            data-idtdrequest="${all.idtdrequest}"
                            data-bs-placement="top"
                            title="">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `
          } else {
            return `
                        <div class="d-flex justify-content-center">
                            <a href="/alumno/verSolicitudEnviada/${all.idtdrequest}" class="btn btn-info shadow btn-xs sharp me-1"
                            target="_blank"
                            data-bs-placement="top"
                            title="Ver Solicitud">
                            <i class="fas fa-file-lines fa-lg"></i>
                            </a>
                        </div>
                        `
          }
        }
      },
      {
        data: 'estado',
        className: 'text-center',
        render: function (data, type, all, meta) {
          if (all.estado == '0') {
            return `<span class="btn btn-dark btn-sm btn-rounded">Pendiente</span>`
          } else if (all.estado == '1') {
            return `<span class="btn btn-success btn-sm btn-rounded">Finalizado</span>`
          } else if (all.estado == '2') {
            return `<span class="btn btn-info btn-sm btn-rounded">Visto</span>`
          } else if (all.estado == '3') {
            return `<span class="btn btn-dark btn-sm btn-rounded">Rechazado</span>`
          }
        }
      },
      { data: 'fecha', className: 'text-center' }
    ]
  })

  // Agregar una columna de números automáticos
  table.on('order.dt search.dt', function () {
    table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
      cell.innerHTML = i + 1
    })
  }).draw()

  var valbtn, formCheck

  // INICIO - MODAL CREATE
  $('#btnCreateModal').click(function () {
    // change value
    $('#btnCreateUpdate').attr('value', 'Create')
    $('#btnCreateUpdate').html('Registrar')
    $('#modalCreateUpdateLabel').html('Nueva solicitud')
    // mostrar div
    clearForm() // limpiar formulario
    // limpiar validaciones
    formCheck = $('#formModal')[0]
    $(formCheck).removeClass('was-validated') // remover validaciones
  })
  // FIN - MODAL CREATE

  // INICIO - FUNCION CREATE O UPDATE
  $('#btnCreateUpdate').on('click', function (event) {
    event.preventDefault()
    // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
    formCheck = $('#formModal')[0]
    if (!formCheck.checkValidity()) {
      event.preventDefault()
      event.stopPropagation()
    } else {
      valbtn = $('#btnCreateUpdate').val()
      // FUNCION CREAR
      if (valbtn === 'Create') {
        // insertar
        store()
      }
    }
    $(formCheck).addClass('was-validated'); // añadir validaciones
  })
  // FIN - FUNCION CREATE O UPDATE

  var estado = false
  function store () {
    confirmation_sweetAlert('Deseas continuar?', 'Se procederá a registrar tu solicitud de trámite documentario, con la información ', 'warning')
      .then(function (isConfirm) {
        if (isConfirm.value) {
          // FUNCION REGISTRAR TRAMITE
          if (estado === true) {
            document.getElementById('formModal').classList.remove('was-validated')
            document.getElementById('name_File_documento').classList.remove('is-invalid')
            estado = false
          }
          var formData = new FormData(document.getElementById('formModal'))
          $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/alumno/solicitudes/store',
            data: formData,
            processData: false,
            contentType: false,
            beforeSend: function () {
              notificaciontoast('warning', 'Validando información!', 'Mensaje!')
            },
            success: function (response) {
              if (response.status == true) {
                notificaciontoast('info', response.mensaje, 'Éxitos!')
                document.getElementById('formModal').classList.remove('was-validated')
                document.getElementById('formModal').reset()
                table.ajax.reload()
                table2.ajax.reload()
                $('#modalCreateUpdate').modal('hide')
                $('#btnCreateUpdate').removeClass('disabled')
              } else if (response.status == false) {
                if (typeof response.mensaje.name_File_documento != 'undefined') {
                  document.getElementById('name_File_documento').classList.add('is-invalid')
                  document.getElementById('validate_message_File_docuemento').innerHTML = response.mensaje.name_File_documento[0]
                }
                estado = true
              } else {
                setTimeout(function () {
                  window.location = route_login
                }, 1150)
              }
            },
            error: function (error) {
              notificaciontoast('error', error, 'Error!')
            }
          })
        } else {
          console.log('Cancelado')
        }
      })
  }

  // LIMPIAR FORMULARIO
  function clearForm () {
    $('#txt-request_type').selectpicker('val', '')
    $('#txt-asunto').val('')
    $('#txt-folios').val('')
    $('#txt-documento').val('')
  }

  // FUNCION BOTON REFRESH
  $('#btnRefresh').on('click', function () {
    table.ajax.reload()
    table2.ajax.reload()
  })

  // LISTAR DATATABLE 2
  var table2 = $('#datatableGeneral_finalizados').DataTable({
    createdRow: function (row, data, index) {
      $(row).addClass('selected')
    },
    order: [],
    ajax: {
      headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
      type: 'POST',
      url: '/alumno/solicitudes/list/1'
    },
    searching: true,
    pageLength: 12, // 12 filas
    dom: 'Bfrtip',
    select: false,
    lengthChange: false,
    responsive: true,
    language: {
      search: 'Buscar',
      info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
      zeroRecords: 'No hay registros para mostrar.',
      infoFiltered: '(Filtrados de _MAX_ Registros)',
      emptyTable: 'La tabla está vacia.',
      infoEmpty: 'No hay registros',
      paginate: {
        next: '<i class="fa-solid fa-angle-right"></i>',
        previous: '<i class="fa-solid fa-angle-left"></i>'
      }
    },
    buttons: [
      {
        extend: 'excel',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      },
      {
        extend: 'pdf',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded ',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      },
      {
        extend: 'print',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      },
      {
        extend: 'colvis',
        text: 'Seleccionar celdas',
        title: 'Reporte de ' + tableName,
        type: 'button',
        orientation: 'landscape',
        className: 'btn btn-sm btn-arounded',
        exportOptions: {
          columns: ':visible',
          columns: ':not(.noExport)',
          orthogonal: 'print'
        }
      }
    ],
    columns: [
      { data: 'idtdrequest', className: 'text-center' },
      { data: 'codigo', className: 'text-center' },
      { data: 'tipo', className: 'text-center' },
      { data: 'asunto', className: 'text-center' },
      { data: 'folios', className: 'text-center' },
      { data: 'ruta_file', sortable: false, className: 'text-center',
          render: function (data, type, all, meta) {
            if (all.ruta_file == null) {
              return '--'
            } else if (all.ruta_file == '--') {
              return `
                          <div class="d-flex justify-content-center">
                              <a href="javascript:void(0);" class="btn btn-dark shadow btn-xs sharp disabled"
                              data-idtdrequest="${all.idtdrequest}"
                              data-bs-placement="top"
                              title="">
                              <i class="fas fa-file-lines fa-lg"></i>
                              </a>
                          </div>
                          `
            } else {
              return `
                          <div class="d-flex justify-content-center">
                              <a href="/alumno/verSolicitudEnviada/${all.idtdrequest}" class="btn btn-info shadow btn-xs sharp me-1"
                              target="_blank"
                              data-bs-placement="top"
                              title="Ver Solicitud">
                              <i class="fas fa-file-lines fa-lg"></i>
                              </a>
                          </div>
                          `
            }
          }
      },
      { data: 'rpta_ruta', sortable: false, className: 'text-center',
          render: function (data, type, all, meta) {
            if (all.rpta_ruta == null) {
              return '--'
            } else if (all.rpta_ruta == '--') {
              return `
                          <div class="d-flex justify-content-center">
                              <a href="javascript:void(0);" class="btn btn-dark shadow btn-xs sharp disabled"
                              data-idtdrequest="${all.idtdrequest}"
                              data-bs-placement="top"
                              title="">
                              <i class="fas fa-file-lines fa-lg"></i>
                              </a>
                          </div>
                          `
            } else {
              return `
                          <div class="d-flex justify-content-center">
                              <a href="/alumno/verSolicitudRespuesta/${all.idtdrequest}" class="btn btn-info shadow btn-xs sharp me-1"
                              target="_blank"
                              data-bs-placement="top"
                              title="Ver Respuesta">
                              <i class="fas fa-file-lines fa-lg"></i>
                              </a>
                          </div>
                          `
            }
          }
      },
      { data: 'estado', className: 'text-center',
          render: function (data, type, all, meta) {
            if (all.estado == '0') {
              return `<span class="btn btn-dark btn-sm btn-rounded">Pendiente</span>`
            } else if (all.estado == '1') {
              return `<span class="btn btn-success btn-sm btn-rounded">Finalizado</span>`
            } else if (all.estado == '2') {
              return `<span class="btn btn-info btn-sm btn-rounded">Visto</span>`
            } else if (all.estado == '3') {
              return `<span class="btn btn-dark btn-sm btn-rounded">Rechazado</span>`
            }
          }
      },
      { data: 'fecha', className: 'text-center' },
      { data: 'rpta_fecha', className: 'text-center' }
    ]
  })

  // Agregar una columna de números automáticos
  table2.on('order.dt search.dt', function () {
    table2.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
      cell.innerHTML = i + 1
    })
  }).draw()



  cb_roles2();
  function cb_roles2() {
      $.ajax({
          type: "GET",
          url: '/ajax_all/roles2',
          dataType: 'json',
          beforeSend: function () { },
          success: function (response) {
              $("#txt-idrole").append('<option selected disabled value="">Seleccione opción</option>');
              response.forEach((elemento) => {
                  $("#txt-idrole").append('<option value="' + elemento.id + '" >' + elemento.nombre + '</option>');
              })
              $("#txt-idrole").selectpicker("refresh");
          },
          error: function (error) {
              console.log("Error", error);
          },
      });
  } 
})
