//"use strict";
import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {
    const tableName = "General de Horarios ";

    //LISTAR DATATABLE
    let dt_idsemester = 0 ;
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: "POST",
            url: '/docente/horarios/list',
            data: function (d) {
                d.idsemester = dt_idsemester;
            },
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: function () {
                    return (
                        "Reporte de Horarios " + semester
                    );
                },
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
  
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                text: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            { data: "programa", className: "text-start", name: "primero",
                render: function (data, type, all, meta) {
                    return `<div class="timeline-panel text-muted">
                                <span><strong class="text-info">${all.programa}</strong></span>
                            </div>`
                },
            },
            { data: "plan", className: "text-center bg-primary", },
            { data: "periodo", className: "text-center bg-primary", },
            { data: "codcurso", className: "text-center bg-primary", },
            { data: "curso", className: "text-center bg-primary", },
            { data: "tipo", className: "text-center bg-primary", },
            { data: "condicion", className: "text-center bg-primary", },
            { data: "turno", className: "text-center bg-primary", },
            { data: "seccion", className: "text-center bg-primary", },
            { data: "Lunes", className: "text-center bg-info", },
            { data: "Martes", className: "text-center bg-info", },
            { data: "Miercoles", className: "text-center bg-info", },
            { data: "Jueves", className: "text-center bg-info", },
            { data: "Viernes", className: "text-center bg-info", },
            { data: "Sabado", className: "text-center bg-info", },
            { data: "aula", className: "text-center bg-primary", },
        ],
        rowsGroup: [
            'primero:name',
        ],
        orderFixed: [0, 'asc'],
    });


    //--------- F U N C I O N E S --------------//
    cb_semesters();
    function cb_semesters() {
        $("#txt_semestre").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/semestersDocentes',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#txt_semestre").append('<option selected disabled value="">Seleccione semestre  </option>');
                response.forEach((elemento) => {
                    $("#txt_semestre").append('<option' +
                        ' value="' + elemento.id + '" ' +
                        ' data-anho="' + elemento.anho + '" ' +
                        ' data-numero="' + elemento.numero + '" ' +
                        ' data-fecinicio="' + elemento.fecinicio + '" ' +
                        ' data-fecfin="' + elemento.fecfin + '" ' +
                        '>' + elemento.anho + " - " + elemento.numero + '</option>');
                })
                $("#txt_semestre").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    let selectedOption;
    $("#txt_semestre").on('change', function () {
        toastr.info("Consultando en la base de datos ....", "Mensaje", {
            positionClass: "toast-bottom-right", timeOut: 2000, closeButton: !0, debug: !1, newestOnTop: !0, progressBar: !0, preventDuplicates: !0, onclick: null, showDuration: "300", hideDuration: "1000", extendedTimeOut: "1000", showEasing: "swing", hideEasing: "linear", showMethod: "fadeIn", hideMethod: "fadeOut", tapToDismiss: !1
        });
        dt_idsemester = $(this).val();
        console.log(dt_idsemester);
        table.ajax.reload();
    });

});
