import { notificaciontoast } from '../jsAjaxToastSweetalert/method_toast.js'
import { confirmation_sweetAlert } from '../jsAjaxToastSweetalert/method_sweetAlert.js'
$(document).ready(function () {

    //JAVASCRIPT EVENTOS PENDIENTES
    const tableName01 = 'Programacion pendiente';

    var table = $("#datatableGeneralPendientes").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: '/docente/programacion/ajax_all/eventos/pendientes',
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName01,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName01,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName01,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                txt: "Seleccionar celdas",
                title: "Reporte de " + tableName01,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            {data: "namecurso",
            className: "text-start mx-2",

            render: function (data, type, all, meta) {
                return "<h5><strong>" + all.namecurso + "</strong></h5>" +
                        "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + "<strong> Turno:</strong> " + all.turno + "<br>"+
                        "<strong>Fecha: </strong>" + all.fecha + " <br>"+
                        "<strong>Hora: </strong>" + all.horario + " </p>"
            }},
            { data: 'tipo_programacion', className: 'text-start' },
            { data: 'nombre_evento', className: 'text-start' },
            { data: 'descripcion', className: 'text-start' },
            {
                data: "id", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="uploadBtn btn btn-info shadow btn-xs sharp  me-1"
                                data-idasigcalendar = "${all.id}"
                                data-codcurso = "${all.codcurso}"
                                data-bs-placement="top"
                                title="Cargar archivo al evento">
                                <i class="fas fa-upload"></i>
                                </a>
                                <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp"
                                data-bs-placement="top"
                                title="Eliminar registro"
                                data-idasigcalendar = "${all.id}"
                                >
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>
                            `;
                },
            },
        ]
    });

    $("#datatableGeneralPendientes tbody").on("click", ".uploadBtn", function (event) {
        event.preventDefault();
        document.getElementById('formModalAsignarfileevento').classList.remove('was-validated')
        document.getElementById('formModalAsignarfileevento').reset();
        $("#id_evento_asig").val($(this).data("idasigcalendar"));
        $("#txt_data_cod_curso").val($(this).data("codcurso"));
        $("#modalAsignarfileevento").modal("show");
    });

    var estado = false;
    $("#btnSaveprogramacion").on("click", function (event) {
        event.preventDefault();
        let formCheck = $('#formModalAsignarfileevento')[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();

        } else {
            confirmation_sweetAlert("Deseas continuar?", "Se procederá a activar el evento, con la información ", "warning")
                .then(function (isConfirm) {
                    if (isConfirm.value) {
                        //FUNCION REGISTRAR TRAMITE
                        if (estado === true) {
                            document.getElementById('formModalAsignarfileevento').classList.remove('was-validated');
                            document.getElementById('file_eventoAsignado').classList.remove('is-invalid');
                            estado = false;
                        }
                        var formData = new FormData(document.getElementById('formModalAsignarfileevento'));
                        $.ajax({
                            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                            type: 'POST',
                            url: '/docente/programacion/asignar/file',
                            data: formData,
                            processData: false,
                            contentType: false,
                            beforeSend: function () {
                                notificaciontoast("warning", "Validando información!", "Mensaje!");
                            },
                            success: function (response) {
                                if (response.status == true) {
                                    notificaciontoast("info", response.mensaje, "Éxitos!");
                                    document.getElementById('formModalAsignarfileevento').classList.remove('was-validated')
                                    document.getElementById('formModalAsignarfileevento').reset();
                                    $("#txt_data_cod_curso").val("");
                                    $("#id_evento_asig").val("");
                                    table.ajax.reload();
                                    $("#modalAsignarfileevento").modal("hide");

                                } else if (response.status == false) {

                                    if (typeof response.mensaje.file_eventoAsignado != 'undefined') {
                                        document.getElementById('file_eventoAsignado').classList.add('is-invalid');
                                        document.getElementById('validate_message_File_docuemento').innerHTML = response.mensaje.file_eventoAsignado[0];
                                    }
                                    estado = true;
                                }

                            },
                            error: function (error) {
                                notificaciontoast("error", error, "Error!");
                            },
                        });

                    } else {
                        console.log("Cancelado");
                    }
                });


        }
        $(formCheck).addClass('was-validated'); // añadir validaciones

    });

    $("#datatableGeneralPendientes tbody").on("click", ".deleteBtn", function (e) {
        let idasigcalendar =   $(this).data("idasigcalendar");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    $.ajax({
                        headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                        type: "DELETE",
                        url: '/docente/programacion/eventos/pendientes/destroy/' + idasigcalendar,
                        beforeSend: function () { },
                        success: function (data) {
                            if (data.status == true) {
                                table.ajax.reload();
                                notificaciontoast("info", data.mensaje, "Éxito!");
                            } else {
                                notificaciontoast("error", data.mensaje, "Error!");
                            }
                        },
                        error: function (error) {
                            console.log("Error", error);
                        },
                    });
                } else {
                    console.log("Cancelado");
                }
            });
    });
    //FIN






     //JAVASCRIPT EVENTOS ASIGNADOS
    const tableName02 = 'Programacion Asignada';

    var table2 = $("#datatableGeneralAsginados").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: '/docente/programacion/ajax_all/eventos/asignados',
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName02,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName02,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName02,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                txt: "Seleccionar celdas",
                title: "Reporte de " + tableName02,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            {data: "namecurso", className: "text-start mx-2",
                render: function (data, type, all, meta) {
                    return "<h5><strong>"+ all.codcurso + " - "+ all.namecurso + "</strong></h5>" +
                            "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + "<strong> Turno:</strong> " + all.turno + "<br>"+
                            "<strong>Fecha: </strong>" + all.fecha + " <br>"+
                            "<strong>Hora: </strong>" + all.horario + " </p>"
                }
            },
            { data: 'tipo_programacion', className: 'text-start' },
            { data: 'nombre_evento', className: 'text-start' },
            { data: 'descripcion', className: 'text-start' },
            {data: "horaini", className: "text-start mx-2",
                render: function (data, type, all, meta) {
                    return "<strong>Desde: </strong>" + all.horaini + " <br>"+
                            "<strong>Hasta: </strong>" + all.horafin + " </p>"
                    }
            },
            { data: 'tiempoduracion', className: 'text-center' },
            { data: 'horaextend', className: 'text-center' },
            {
                data: "archivo",
                sortable: false,
                className: "text-center",

                render: function (data, type, all, meta) {
                    if(all.archivo != "-"){
                        return  `<a href="/docente/programacion/asignada/viewfile/${all.id}/${all.codcurso}/${all.archivo}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                    <i class="fa-solid fa-file-pdf fa-xl"></i>
                                </a>`;
                    }else{
                        return  `No asignado`;
                    }

                },
            },
            {
                data: "id", className: "text-center noExport", sortable: false, searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="updateBtn btn btn-dark shadow btn-xs sharp  me-1"
                                data-bs-placement="top"
                                data-idasigcalendar = "${all.id}"
                                data-idasigprogram = "${all.idasigpro}"
                                data-archivo = "${all.archivo}"
                                data-codcurso = "${all.codcurso}"
                                data-horainicio = "${all.horaini}"
                                data-horafin = "${all.horafin}"
                                title="Editar el archivo">
                                <i class="fas fa-upload"></i>
                                </a>
                                <a href="javascript:void(0);" class="returnBtn btn btn-info shadow btn-xs sharp me-1"
                                data-bs-placement="top"
                                data-idasigcalendar = "${all.id}"
                                data-codcurso = "${all.codcurso}"
                                data-archivo = "${all.archivo}"
                                title="Retornar a pendiente">
                                <i class="fas fa-undo"></i>
                                </a>
                                <a href="javascript:void(0);" class="deleteBtn btn btn-dark shadow btn-xs sharp me-1"
                                data-bs-placement="top"
                                data-idasigcalendar = "${all.id}"
                                data-codcurso = "${all.codcurso}"
                                data-archivo = "${all.archivo}"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>
                                <a href="javascript:void(0);" class="finalizarBtn btn btn-primary shadow btn-xs sharp"
                                data-bs-placement="top"
                                data-idasigcalendar = "${all.id}"
                                title="Finalizar Evento">
                                <i class="fas fa-hourglass-end"></i>
                                </a>

                            </div>
                            `;
                },
            },
        ]
    });

    $("#datatableGeneralAsginados tbody").on("click", ".deleteBtn", function (e) {

        event.preventDefault();

        var idasig = $(this).data("idasigcalendar");
        var codcurso =   $(this).data("codcurso");
        var archivo =   $(this).data("archivo");

        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el evento asginado y los documentos", "warning")
        .then(function (isConfirm) {
            if (isConfirm.value) {
                $.ajax({
                    headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                    type: "DELETE",
                    url: '/docentes/programacion/evento/asginado/destroy/'+idasig+'/'+codcurso+'/'+archivo,
                    beforeSend: function () { },
                    beforeSend: function () {
                        notificaciontoast("warning", "procesando, eliminar evento asginado!", "Mensaje!");
                    },
                    success: function (data) {
                        if (data.status == true) {
                            table2.ajax.reload();
                            notificaciontoast("info", data.mensaje, "Éxito!");
                        } else {
                            notificaciontoast("error", data.mensaje, "Error!");
                        }
                    },
                    error: function (error) {
                        console.log("Error", error);
                    },
                });

            } else {
                console.log("Cancelado");
            }
        });
    });

    $("#datatableGeneralAsginados tbody").on("click", ".returnBtn", function (e) {

        event.preventDefault();

        var idasig = $(this).data("idasigcalendar");
        var codcurso =   $(this).data("codcurso");
        var archivo =   $(this).data("archivo");

        confirmation_sweetAlert("Deseas continuar?", "Se procederá a retornar a pendiente el evento asginado y los documentos de eliminarán", "warning")
        .then(function (isConfirm) {
            if (isConfirm.value) {
                $.ajax({
                    headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                    type: "PUT",
                    url: '/docentes/programacion/evento/asginado/returnpendiente/'+idasig+'/'+codcurso+'/'+archivo,
                    beforeSend: function () { },
                    beforeSend: function () {
                        notificaciontoast("warning", "procesando, eliminar evento asginado!", "Mensaje!");
                    },
                    success: function (data) {
                        if (data.status == true) {
                            table2.ajax.reload();
                            notificaciontoast("info", data.mensaje, "Éxito!");
                        } else {
                            notificaciontoast("error", data.mensaje, "Error!");
                        }
                    },
                    error: function (error) {
                        console.log("Error", error);
                    },
                });

            } else {
                console.log("Cancelado");
            }
        });
    });

    $("#datatableGeneralAsginados tbody").on("click", ".updateBtn", function (e) {
        event.preventDefault();
        document.getElementById('formModaluploadFile').classList.remove('was-validated')
        document.getElementById('formModaluploadFile').reset();
        $("#id_evento_asigcalendario_upload").val($(this).data("idasigcalendar"));
        $("#id_evento_asigpropgram_upload").val($(this).data("idasigprogram"));
        $("#txt_data_cod_curso_upload").val($(this).data("codcurso"));
        $("#txt_data_archivo_upload").val($(this).data("archivo"));

        $("#data_horainicio_upload").val($(this).data("horainicio"));
        $("#data_horafin_upload").val($(this).data("horafin"));
        $("#modalUdateFile").modal("show");
    });

    var estado2 = false;
    $("#btnUpdateprogramacion").on("click", function (event) {
        event.preventDefault();
        let formCheck = $('#formModaluploadFile')[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();

        } else {
            confirmation_sweetAlert("Deseas continuar?", "Se procederá a actualilzar los datos del evento", "warning")
                .then(function (isConfirm) {
                    if (isConfirm.value) {
                        //FUNCION REGISTRAR TRAMITE
                        if (estado2 === true) {
                            document.getElementById('formModaluploadFile').classList.remove('was-validated');
                            document.getElementById('file_eventoAsignado_upload').classList.remove('is-invalid');
                            estado2 = false;
                        }
                        var formData = new FormData(document.getElementById('formModaluploadFile'));
                        $.ajax({
                            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                            type: 'POST',
                            url: '/docente/programacion/asignar/file/update',
                            data: formData,
                            processData: false,
                            contentType: false,
                            beforeSend: function () {
                                notificaciontoast("warning", "Validando información!", "Mensaje!");
                            },
                            success: function (response) {
                                if (response.status == true) {
                                    notificaciontoast("info", response.mensaje, "Éxitos!");
                                    document.getElementById('formModaluploadFile').classList.remove('was-validated')
                                    document.getElementById('formModaluploadFile').reset();
                                    $("#txt_data_cod_curso_upload").val("");
                                    $("#id_evento_asigcalendario_upload").val("");
                                    $("#id_evento_asigpropgram_upload").val("");
                                    $("#txt_data_archivo_upload").val("");
                                    table2.ajax.reload();
                                    $("#modalUdateFile").modal("hide");

                                } else if (response.status == false) {
                                    if (typeof response.mensaje.file_eventoAsignado_upload != 'undefined') {
                                        document.getElementById('file_eventoAsignado_upload').classList.add('is-invalid');
                                        document.getElementById('validate_message_File_docuemento_upload').innerHTML = response.mensaje.file_eventoAsignado_upload[0];
                                    }
                                    estado2 = true;
                                }

                            },
                            error: function (error) {
                                notificaciontoast("error", error, "Error!");
                            },
                        });

                    } else {
                        console.log("Cancelado");
                    }
                });


        }
        $(formCheck).addClass('was-validated'); // añadir validaciones

    });

    $("#datatableGeneralAsginados tbody").on("click", ".finalizarBtn", function (e) {
        let idasigcalendar =   $(this).data("idasigcalendar");
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a dar por finalizado el evento", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    $.ajax({
                        headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                        type: "PUT",
                        url: '/docente/programacion/eventos/pendientes/finalizar/' + idasigcalendar,
                        beforeSend: function () { },
                        success: function (data) {
                            if (data.status == true) {
                                table2.ajax.reload();
                                notificaciontoast("info", data.mensaje, "Éxito!");
                            } else {
                                notificaciontoast("error", data.mensaje, "Error!");
                            }
                        },
                        error: function (error) {
                            console.log("Error", error);
                        },
                    });
                } else {
                    console.log("Cancelado");
                }
            });
    });

    //FIN






     //JAVASCRIPT EVENTOS ASIGNADOS
     const tableName03 = 'Programacion Asignada';

     var table3 = $("#datatableGeneralEvntfianlizado").DataTable({
         createdRow: function (row, data, index) {
             $(row).addClass("selected");
         },
         order: [],
         ajax: '/docente/programacion/ajax_all/eventos/finalizados',
         pageLength: 12, // 12 filas
         searching: true,
         dom: "Bfrtip",
         select: false,
         lengthChange: false,
         responsive: true,
         language: {
             search: 'Buscar',
             info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
             zeroRecords: 'No hay registros para mostrar.',
             infoFiltered: '(Filtrados de _MAX_ Registros)',
             emptyTable: 'La tabla está vacia.',
             infoEmpty: 'No hay registros',
             paginate: {
                 next: '<i class="fa-solid fa-angle-right"></i>',
                 previous: '<i class="fa-solid fa-angle-left"></i>'
             }
         },
         buttons: [
             {
                 extend: "excel",
                 title: "Reporte de " + tableName03,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
             {
                 extend: "pdf",
                 title: "Reporte de " + tableName03,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded ",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
             {
                 extend: "print",
                 title: "Reporte de " + tableName03,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
             {
                 extend: "colvis",
                 txt: "Seleccionar celdas",
                 title: "Reporte de " + tableName03,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
         ],
         columns: [
             {data: "namecurso",
                 className: "text-start mx-2",

                 render: function (data, type, all, meta) {
                     return "<h5><strong>" + all.codcurso +" - " + all.namecurso + "</strong></h5>" +
                             "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + "<strong> Turno:</strong> " + all.turno + "<br>"+
                             "<strong>Fecha: </strong>" + all.fecha + " <br>"+
                             "<strong>Hora: </strong>" + all.horario + " </p>"
                 }
             },
             { data: 'tipo_programacion', className: 'text-start' },
             { data: 'nombre_evento', className: 'text-start' },
             { data: 'descripcion', className: 'text-start' },
             {data: "horaini",
             className: "text-start mx-2",

             render: function (data, type, all, meta) {
                 return "<strong>Desde: </strong>" + all.horaini + " <br>"+
                         "<strong>Hasta: </strong>" + all.horafin + " </p>"
                 }
             },
             { data: 'tiempoduracion', className: 'text-center' },
            { data: 'horaextend', className: 'text-center' },
             {
                data: "archivo",
                sortable: false,
                className: "text-center",

                render: function (data, type, all, meta) {
                    if(all.archivo != "-"){
                        return  `<a href="/docente/programacion/asignada/viewfile/${all.id}/${all.codcurso}/${all.archivo}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`;
                    }else{
                        return  `No asignado`;
                    }

                },
            },
             {data: "id",
             className: "text-start mx-2",

             render: function (data, type, all, meta) {
                 return `<span class="badge light badge-danger">Pendiente de evaluar</span>`;
                 }
             },
             {
                 data: "id", className: "text-center noExport", sortable: false, searchable: false,
                 render: function (data, type, all, meta) {
                     return `
                             <div class="d-flex justify-content-center">
                                 <a href="javascript:void(0);" class="evaluarBtn btn btn-info shadow btn-xs sharp  me-1"
                                 data-bs-placement="top"
                                 title="Ver lista de alumnos">
                                 <i class="fas fa-user"></i>
                                 </a>
                                 <a href="javascript:void(0);" class="extendereventoBtn btn btn-primary shadow btn-xs sharp"
                                 data-bs-placement="top"
                                 data-idasigcalendar = "${all.id}"
                                 data-idasigprogram = "${all.idasigpro}"
                                 data-horaini = "${all.horaini}"
                                 data-horafin = "${all.horafin}"
                                 title="Aperturar nuevamente">
                                 <i class="fas fa-hourglass-end"></i>
                                 </a>

                             </div>
                             `;
                 },
             },
         ]
     });

     $("#datatableGeneralEvntfianlizado tbody").on("click", ".evaluarBtn", function (e) {
        event.preventDefault();
        $("#modalListEstudiantes").modal("show");
    });


    $("#datatableGeneralEvntfianlizado tbody").on("click", ".extendereventoBtn", function (e) {
        event.preventDefault();
        document.getElementById('formModalhabilitarevento').classList.remove('was-validated')
        document.getElementById('formModalhabilitarevento').reset();
        $("#id_evento_asigcalendario_extend").val($(this).data("idasigcalendar"));
        $("#id_evento_asigpropgram_extend").val($(this).data("idasigprogram"));
        $("#hora_inicio").html($(this).data("horaini"));
        $("#hora_fin").html($(this).data("horafin"));
        $("#modalhabilitarevento").modal("show");
    });


    $("#btnUpdateprogramacionExtend").on("click", function (event) {
        event.preventDefault();
        let formCheck = $('#formModalhabilitarevento')[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();

        } else {
            confirmation_sweetAlert("Deseas continuar?", "Se procederá a extender el horario del evento", "warning")
                .then(function (isConfirm) {
                    if (isConfirm.value) {
                        var formData = $('#formModalhabilitarevento').serialize();
                        $.ajax({
                            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                            type: 'PUT',
                            url: '/docente/programacion/eventos/asignado/extend',
                            data: formData,
                            dataType: 'json',
                            beforeSend: function () { notificaciontoast('warning', "Procesando registro", 'Mensaje!') },
                            success: function (data) {
                                if (data.status == true) {
                                    notificaciontoast('info', data.mensaje, 'Éxito!')
                                    table3.ajax.reload();
                                    $("#modalhabilitarevento").modal("hide");
                                } else {
                                    notificaciontoast('error', data.mensaje, 'Error!')
                                }
                            },
                            error: function (error) {
                                console.log('Error', error)
                            }
                        })

                    } else {
                        console.log("Cancelado");
                    }
                });


        }
        $(formCheck).addClass('was-validated'); // añadir validaciones

    });


    //FIN




     //DTATABLE EVENTOS EVALUADOS
     const tableName04 = 'Programacion de eventos evaluados';

     var table4 = $("#datatableGeneralEvaluados").DataTable({
         createdRow: function (row, data, index) {
             $(row).addClass("selected");
         },
         order: [],
         ajax: '/docente/programacion/ajax_all/eventos/evaluados',
         pageLength: 12, // 12 filas
         searching: true,
         dom: "Bfrtip",
         select: false,
         lengthChange: false,
         responsive: true,
         language: {
             search: 'Buscar',
             info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
             zeroRecords: 'No hay registros para mostrar.',
             infoFiltered: '(Filtrados de _MAX_ Registros)',
             emptyTable: 'La tabla está vacia.',
             infoEmpty: 'No hay registros',
             paginate: {
                 next: '<i class="fa-solid fa-angle-right"></i>',
                 previous: '<i class="fa-solid fa-angle-left"></i>'
             }
         },
         buttons: [
             {
                 extend: "excel",
                 title: "Reporte de " + tableName04,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
             {
                 extend: "pdf",
                 title: "Reporte de " + tableName04,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded ",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
             {
                 extend: "print",
                 title: "Reporte de " + tableName04,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
             {
                 extend: "colvis",
                 txt: "Seleccionar celdas",
                 title: "Reporte de " + tableName04,
                 type: "button",
                 orientation: "landscape",
                 className: "btn btn-sm btn-arounded",
                 exportOptions: {
                     columns: ":visible",
                     orthogonal: "print",
                 },
             },
         ],
         columns: [
             {data: "namecurso",
                 className: "text-start mx-2",

                 render: function (data, type, all, meta) {
                     return "<h5><strong>" + all.codcurso +" - " + all.namecurso + "</strong></h5>" +
                             "<p style='font-size:12px'><strong> Sección:</strong> " + all.seccion + "<strong> Turno:</strong> " + all.turno + "<br>"+
                             "<strong>Fecha: </strong>" + all.fecha + " <br>"+
                             "<strong>Hora: </strong>" + all.horario + " </p>"
                 }
             },
             { data: 'tipo_programacion', className: 'text-start' },
             { data: 'nombre_evento', className: 'text-start' },
             { data: 'descripcion', className: 'text-start' },
             {data: "horaini",
             className: "text-start mx-2",

             render: function (data, type, all, meta) {
                 return "<strong>Desde: </strong>" + all.horaini + " <br>"+
                         "<strong>Hasta: </strong>" + all.horafin + " </p>"
                 }
             },
            { data: 'horaextend', className: 'text-center' },
            { data: 'tiempoduracion', className: 'text-center' },
             {
                data: "archivo",
                sortable: false,
                className: "text-center",

                render: function (data, type, all, meta) {
                    if(all.archivo != "-"){
                        return  `<a href="/docente/programacion/asignada/viewfile/${all.id}/${all.codcurso}/${all.archivo}"  target="_blank" data-bs-placement="top"  title="Archivo cargado" class="text-danger">
                                     <i class="fa-solid fa-file-pdf fa-xl"></i>
                                 </a>`;
                    }else{
                        return  `No asignado`;
                    }

                },
            },
             {data: "id",
             className: "text-center",

             render: function (data, type, all, meta) {
                 return `<div class="icon-box icon-box-sm bg-primary">
                            <h6 class="text-light mb-0 font-w600">${all.totalalumnos}</h6>
                        </div>`;
                 }
             },
             {data: "horaini",
             className: "text-start",

             render: function (data, type, all, meta) {
                 return "<span class='badge light badge-success'><i class='fa fa-circle text-success me-1'></i> Rindieron: "+ all.totalalumnosrindieron +"</span><br>"+
                        "<span class='badge light badge-danger m-0'><i class='fa fa-circle text-danger me-1'></i> Faltantes: "+ (all.totalalumnos-all.totalalumnosrindieron) +"</span>"
                 }
             },
         ]
     });
    //FIN

    $('#btn_secTable_home1').on('click', function (e) {
        e.preventDefault();
        table.ajax.reload();
    });
    $('#btn_secTable_profile1').on('click', function (e) {
        e.preventDefault();
        table2.ajax.reload();
    });
    $('#btn_secTable_contact1').on('click', function (e) {
        e.preventDefault();
        table3.ajax.reload();
    });
     $('#btn_secTable_message1').on('click', function (e) {
         e.preventDefault();
         table4.ajax.reload();
     });







})
