"use strict";

import { notificaciontoast } from "../jsAjaxToastSweetalert/method_toast.js";
import { confirmation_sweetAlert } from "../jsAjaxToastSweetalert/method_sweetAlert.js";

$(document).ready(function () {

    var dt_idsubject = "0";

    $.ajax({
        type: "GET",
        url: '/home/docente/dataAsignaturas',
        dataType: 'json',
        success: function (response) {

            if (response.status === true) {
                if (response.data.length > 0) {
                    let html = '';
                    let count = 1;
                    response.data.forEach((e) => {
                        html += `<li>
                                    <div class="timeline-badge info">
                                    </div>
                                    <a class="timeline-panel text-muted" href="#">
                                        <h4 class="mb-0">${e.curso}</h4>
                                        <h6 class="mb-0">Código: <strong class="text-primary">${e.codcurso}</strong> </h6>
                                        <span><strong class="text-info"> Periodo: ${e.periodo} - Créditos: ${e.creditos} - Horas: ${e.horas} </strong></span>
                                        <p class="mb-0">Semestre: ${e.semestre} - Tipo: ${e.tipo_curso}</p>
                                    </a>
                                </li>`;
                        count++;
                    });
                    document.getElementById("total_asign").innerHTML = "Total: " + count;
                    document.getElementById("list_asignaturas").innerHTML = html;
                }
            }

        },
        error: function (error) {
            console.log("Error", error);
        },
    });

    const tableName = "Estudiante por curso";
    var table = $("#datatableGeneral").DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { "X-CSRF-TOKEN": $('input[name="_token"]').val() },
            type: 'POST',
            url: '/home/docente/list_students',
            data: function (d) {
                d.idsubject = dt_idsubject;
            },
        },
        pageLength: 12, // 12 filas
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: {
            search: 'Buscar',
            info: 'Mostrando _START_ a _END_ de _TOTAL_ Registros',
            zeroRecords: 'No hay registros para mostrar.',
            infoFiltered: '(Filtrados de _MAX_ Registros)',
            emptyTable: 'La tabla está vacia.',
            infoEmpty: 'No hay registros',
            paginate: {
                next: '<i class="fa-solid fa-angle-right"></i>',
                previous: '<i class="fa-solid fa-angle-left"></i>'
            }
        },
        buttons: [
            {
                extend: "excel",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "pdf",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded ",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "print",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
            {
                extend: "colvis",
                txt: "Seleccionar celdas",
                title: "Reporte de " + tableName,
                type: "button",
                orientation: "landscape",
                className: "btn btn-sm btn-arounded",
                exportOptions: {
                    columns: ":visible",
                    orthogonal: "print",
                },
            },
        ],
        columns: [
            {
                data: "codcurso",
                className: "text-start",

                render: function (data, type, all, meta) {
                    return `<div class="timeline-panel text-muted">
                                <h6 class="mb-0"><strong class="text-primary">Curso: ${all.codcurso} - ${all.curso}</strong> </h6>
                                <span><strong class="text-info">Semestre: ${all.semestre} - Periodo: ${all.periodo} - Horas: ${all.horas} </strong></span>
                                <p class="mb-0">Créditos: ${all.creditos}</p>
                            </div>`
                },
                name: "primero",
            },
            {
                data: "nroidenti",
                sortable: false,
                className: "text-start",

                render: function (data, type, all, meta) {
                    return (all.nroidenti);
                },
            },
            {
                data: "nombres",
                sortable: false,
                className: "text-start",

                render: function (data, type, all, meta) {
                    return (all.nombres);
                },
            },
            {
                data: "apellido_pa",
                sortable: false,
                className: "text-start",

                render: function (data, type, all, meta) {
                    return (all.apellido_pa);
                },
            },
            {
                data: "apellido_ma",
                sortable: false,
                className: "text-start",

                render: function (data, type, all, meta) {
                    return (all.apellido_ma);
                },
            },
            {
                data: "correo",
                sortable: false,
                className: "text-start",

                render: function (data, type, all, meta) {
                    return (all.correo);
                },
            }
            // {
            //     data: "notalumno",
            //     sortable: false,
            //     className: "text-center",

            //     render: function (data, type, all, meta) {
            //         return (all.notalumno);
            //     },
            // },
            // {
            //     data: "notalumno",
            //     sortable: false,
            //     className: "text-center",
            //     render: function (data, type, all, meta) {
            //         if (parseInt(all.notalumno) === 0) {
            //             return `<span class="badge light badge-secondary">Sin nota</span>`;
            //         } else if (parseInt(all.notalumno) >= 5 && parseInt(all.notalumno) <= 10.4) {
            //             return `<span class="badge light badge-danger">Desaprobado</span>`;
            //         } else if (parseInt(all.notalumno) >= 10.5 && parseInt(all.notalumno) <= 20) {
            //             return `<span class="badge light badge-primary">Aprobado</span>`;
            //         }
            //     },
            // }
        ],
        rowsGroup: [
            'primero:name',
        ],
        orderFixed: [0, 'asc'], // Fija el orden por defecto de la primera columna
    });


    cb_subjects();
    // listar programas
    function cb_subjects() {
        $("#cb-curso").find("option").remove().end() // delete options
        $.ajax({
            type: "GET",
            url: '/ajax_all/teachers/subjects',
            dataType: 'json',
            beforeSend: function () { },
            success: function (response) {
                $("#cb-curso").append('<option selected disabled value="">Seleccione asignatura</option>');
                response.forEach((elemento) => {
                    $("#cb-curso").append('<option ' +
                        'value="' + elemento.idsubject + '" ' +
                        'data-idsubject="' + elemento.idsubject + '" ' +
                        ' >' + elemento.codcurso + ' - ' +
                               elemento.curso + ' - ' +
                               ' sec:' + elemento.seccion +
                        '</option>');
                })
                $("#cb-curso").selectpicker("refresh");
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    $("#cb-curso").on('change', function () {

        // toastr.info("Consultando en la base de datos ....", "Mensaje", {
        //     positionClass: "toast-bottom-right", timeOut: 2000, closeButton: !0, debug: !1, newestOnTop: !0, progressBar: !0, preventDuplicates: !0, onclick: null, showDuration: "300", hideDuration: "1000", extendedTimeOut: "1000", showEasing: "swing", hideEasing: "linear", showMethod: "fadeIn", hideMethod: "fadeOut", tapToDismiss: !1
        // });

        dt_idsubject = $(this).val();

        table.ajax.reload();
    });
});

