import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../../common/schemas.js";

$(document).ready(function () {

    const tableName = "Empresas";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/admin/bolsa_laboral/empresas/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'id', className: 'text-center' },
            { data: 'ruc', className: 'text-center' },
            { data: 'nombre', className: 'text-center' },
            { data: 'direccion', className: 'text-center' },
            { data: 'nrocontacto', className: 'text-center' },
            {
                data: "ishabilitado",
                sortable: false,
                className: "text-center",
                render: function (data, type, all, meta) {
                    if (all.ishabilitado == "1") {
                        return `<span class="badge light badge-success">Activa</span>`;
                    } else {
                        return `<span class="badge light badge-danger">Inactiva</span>`;
                    }
                },
            },
            { data: 'user', className: 'text-center' },
            { data: 'logo', className: 'text-center' },
            {
                data: "id",
                className: "text-center noExport",
                sortable: false,
                searchable: false,
                render: function (data, type, all, meta) {
                    return `
                            <div class="d-flex justify-content-center">

                                <a href="javascript:void(0);" class="editBtn btn btn-warning shadow btn-xs sharp me-1"
                                data-idcompany="${all.id}"
                                data-nombre="${all.nombre}"
                                data-ruc="${all.ruc}"
                                data-direccion="${all.direccion}"
                                data-nrocontacto="${all.nrocontacto}"
                                data-ishabilitado="${all.ishabilitado}"
                                data-user="${all.user}"
                                data-logo="${all.logo}"
                                data-bs-placement="top"
                                title="Editar registro">
                                <i class="fas fa-pencil-alt"></i>
                                </a>

                                <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idcompany="${all.id}"
                                data-bs-placement="top"
                                title="Eliminar registro">
                                <i class="fas fa-trash"></i>
                                </a>

                            </div>

                            `;
                },
            },
        ]
    });


    $("#btn-querydata").on("click", function (event) {
        event.preventDefault();

        if (document.getElementById('txt-ruc').value == "") {
            notificaciontoast("error", "Ingrese número  RUC", "Mensaje!");
            // setear data de programa
            $("#txt-ruc").addClass("border border-danger shadow");
            setTimeout(function () {
                document.getElementById('txt-ruc').focus();
                $("#txt-ruc").removeClass("border border-danger shadow");
            }, 1500);

        } else {

            var nroruc = $("#txt-ruc").val();
            $.ajax({
                type: "GET",
                url: '/admin/bolsa_laboral/empresas/query_data/' + nroruc,
                dataType: 'json',
                beforeSend: function () {
                    notificaciontoast("warning", "Consultando!", "Mensaje!");
                },
                success: function (response) {
                    const dataObj = JSON.parse(response.data);
                    console.log(dataObj)
                    if (dataObj.hasOwnProperty('error')) {
                        notificaciontoast("error", "Datos del RUC no encontrado/invaliddo", "Error!");
                    } else {
                        notificaciontoast("info", response.mensaje, "Éxito!");

                        $("#txt-nombre").val(dataObj.nombre);
                        $("#txt-direccion").val(dataObj.direccion);

                        if(dataObj.estado === "ACTIVO"){
                            $("#txt-activo").selectpicker("val", "1");
                        }else{
                            $("#txt-activo").selectpicker("val", "0");
                        }

                        // setear data de programa
                        $("#txt-nombre").addClass("border border-info shadow");
                        $("#txt-direccion").addClass("border border-info shadow");
                        $("#txt-activo").addClass("border border-info shadow");

                        setTimeout(function () {
                            $("#txt-nombre").removeClass("border border-info shadow");
                            $("#txt-direccion").removeClass("border border-info shadow");
                            $("#txt-activo").removeClass("border border-info shadow");
                        }, 1500);
                    }
                },
                error: function (error) {
                    console.log("Error", error);
                },
            });
        }
    });


    var valbtn, formCheck;

    // INICIO - MODAL CREATE
    $("#btnCreateModal").click(function () {
        // change value
        $("#btnCreateUpdate").attr("value", "Create");
        $("#btnCreateUpdate").html("Registrar");
        $("#modalCreateUpdateLabel").html("Registrar nueva empresa");
        // mostrar contraseña
        $("#div-txt-password").removeAttr("style");
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        clearForm();
    });
    // FIN - MODAL CREATE

    // INICIO - MODAL UPDATE
    $("#datatableGeneral tbody").on("click", ".editBtn", function (e) {
        // limpiar validaciones
        formCheck = $("#formModal")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        //cambiar el text del button
        $("#btnCreateUpdate").attr("value", "Update");
        $("#btnCreateUpdate").html("Actualizar");
        $("#modalCreateUpdateLabel").html("Actualizar datos de la empresa");
        // ocultar txt_password
        $("#div-txt-password").css("display", "none");
        $("#txt-password").val("****"); // para poder pasar el check validity
        // setear data de usuario
        $("#txt-idcompany").val($(this).data("idcompany"));
        $("#txt-nombre").val($(this).data("nombre"));
        $("#txt-ruc").val($(this).data("ruc"));
        $("#txt-direccion").val($(this).data("direccion"));
        $("#txt-nrocontacto").val($(this).data("nrocontacto"));
        $("#txt-activo").selectpicker("val", $(this).attr("data-ishabilitado"));
        $("#txt-user").val($(this).data("user"));
        $("#txt-logo").val($(this).data("logo"));
        // show form
        $("#modalCreateUpdate").modal("show");
    });
    // FIN - MODAL UPDATE

    // INICIO - MODAL UPDATE PASSWORD
    $("#datatableGeneral tbody").on("click", ".passwordBtn", function (e) {
        // borrar validaciones
        formCheck = $("#formModal2")[0];
        $(formCheck).removeClass('was-validated'); // remover validaciones
        // setear data de usuario
        $("#txt_iduser2").val($(this).data("iduser"));
        $("#txt_nroidenti2").val($(this).data("nroidenti"));
        let apenom = $(this).data("apellido_pa") + " " + $(this).data("apellido_ma") + ", " + $(this).data("nombres");
        $("#txt_apenom").val(apenom);
        $("#txt_password2").val("");
        // show form
        $("#modalUpdatePassword").modal("show");
    });
    // FIN - MODAL UPDATE PASSWORD

    // INICIO - MODAL DELETE
    $("#datatableGeneral tbody").on("click", ".deleteBtn", function (e) {
        let idcompany = $(this).data("idcompany")
        // confirmacion
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el registro de la base de datos", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    // enviando el parametro de la data que se procede a delete
                    destroy(idcompany);
                } else {
                    console.log("Cancelado");
                }
            });
    });
    // FIN - MODAL DELETE

    // INICIO - FUNCION CREATE O UPDATE
    $("#btnCreateUpdate").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            valbtn = $("#btnCreateUpdate").val();
            // FUNCION CREAR
            if (valbtn === "Create") {
                // insertar
                store();
            }
            // FUNCION ACTUALIZAR
            if (valbtn === "Update") {
                // actualizar
                update($("#txt-idcompany").val());
            }
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION CREATE O UPDATE

    // INICIO - FUNCION UPDATE PASSWORD
    $("#btnUpdatePassword").on("click", function (event) {
        event.preventDefault();
        // Iterar sobre los formularios y evitar la acción predeterminada si no son válidos
        formCheck = $("#formModal2")[0];
        if (!formCheck.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        } else {
            update_password($("#txt_iduser2").val());
        }
        $(formCheck).addClass('was-validated'); // añadir validaciones
    });
    // FIN - FUNCION UPDATE PASSWORD

    var formModal;

    function store() {
        formModal = $('#formModal');
        $.ajax({
            type: "POST",
            url: '/admin/bolsa_laboral/empresas/store',
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    setTimeout(function () {
                        notificaciontoast("info", data.mensaje, "Éxito!");
                        $("#modalCreateUpdate").modal("hide");
                    }, 1000); // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }

    function update(idcompany) {
        formModal = $('#formModal');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/empresas/update/' + idcompany,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    formModal.addClass("was-validated");    // añadir validaciones
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalCreateUpdate").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function update_password(iduser) {
        formModal = $('#formModal2');
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'PUT',
            url: '/admin/bolsa_laboral/empresas/update_password/' + iduser,
            data: formModal.serialize(),
            dataType: 'json',
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                    setTimeout(function () { $("#modalUpdatePassword").modal("hide"); }, 1000);   // ocultar despues de 1 sec
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log('Error', error)
            }
        })
    }

    function destroy(idcompany) {
        $.ajax({
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: "DELETE",
            url: '/admin/bolsa_laboral/empresas/destroy/' + idcompany,
            beforeSend: function () { },
            success: function (data) {
                if (data.status == true) {
                    table.ajax.reload();
                    notificaciontoast("info", data.mensaje, "Éxito!");
                } else {
                    notificaciontoast("error", data.mensaje, "Error!");
                }
            },
            error: function (error) {
                console.log("Error", error);
            },
        });
    }


    // LIMPIAR FORMULARIO
    function clearForm() {
        $("#txt-idcompany").val("");
        $("#txt-ruc").val("");
        $("#txt-nombre").val("");
        $("#txt-nrocontacto").val("");
        $("#txt-activo").selectpicker("val", "1");
        $("#txt-direccion").val("");
        $("#txt-user").val("");
        $("#txt-password").val("");
    }

});


