import { notificaciontoast } from "../../common/method_toast.js";
import { confirmation_sweetAlert } from "../../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from '../../common/schemas.js';

$(document).ready(function () {
    const tableName = 'Programas Técnicos'

    var tabletec = $('#datatableGeneral_tecnico').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass('selected')
        },
        order: [],
        ajax: routeListtec,
        searching: true,
        dom: 'Bfrtip',
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [{
            data: 'codprograma',
            className: 'text-center'
        },
        {
            data: 'nombre',
            className: 'text-start'
        },
        {
            data: 'id',
            className: 'text-center',
            sortable: false,
            render: function (data, type, all, meta) {
                return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="deleteBtn btn btn-danger shadow btn-xs sharp"
                                data-idprograma="${all.id}"
                                data-bs-placement="top"
                                title="Eliminar registro"
                            >
                                <i class="fas fa-trash"></i>
                            </a>
                        </div>
                        `
            }
        }

        ]

    });

    var table = $('#datatableGeneralcatalogoprogramastec').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            type: 'GET',
            url: '/admin/cargar/catalogo/programas/tec',
        },
        searching: true,
        pageLength: 10, // 12 filas
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: [{
            extend: "excel",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "pdf",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded ",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "print",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        {
            extend: "colvis",
            text: "Seleccionar celdas",
            title: "Reporte de " + tableName,
            type: "button",
            orientation: "landscape",
            className: "btn btn-sm btn-arounded",
            exportOptions: {
                columns: ":visible",
                columns: ":not(.noExport)",
                orthogonal: "print"
            },
        },
        ],
        columns: [
            {
                data: `${[0]}`,
                className: 'text-center',
                render: function (data, type, row, meta) {
                    return `<strong>${row[0]}</strong>`;
                },
            },
            {
                data: `${[1]}`,
                render: function (data, type, row, meta) {
                    return `${row[1]}`;
                },
            },
            {
                data: `${[2]}`,
                className: 'text-center',
                render: function (data, type, row, meta) {
                    return `${row[2]}`;
                },
            },
            {
                data: `${[0]}`,
                className: 'text-center',
                render: function (data, type, row, meta) {
                    return `
                            <div class="d-flex justify-content-center">
                                <a href="javascript:void(0);" class="saveBtn btn btn-info shadow btn-xs sharp"
                                    data-codprograma="${row[0]}"
                                    data-nombreprograma="${row[1]}"
                                    data-bs-placement="top"
                                    title="Registrar programa"
                                >
                                    <i class="fa-solid fa-upload"></i>
                                </a>
                            </div>
                            `
                }
            }

        ],
    });

    $("#modalCreateUpdate_p").on("click", function (event) {
        event.preventDefault();
        document.getElementById("modalcatalogoprogramastecLabel").innerHTML = "Catalogo de programas nivel formativo: Técnico";
        $("#modalcatalogoprogramastec").modal("show");
    });

    $('#modalcatalogoprogramastec tbody').on('click', '.saveBtn', function (e) {

        let codprograma = $(this).attr("data-codprograma");
        let nombreprograma = $(this).attr("data-nombreprograma");

        confirmation_sweetAlert("Deseas continuar?", "Se procederá a registrar el progrema seleccionado", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    $.ajax({
                        headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                        type: 'POST',
                        url: routeStore,
                        data: {
                            codprograma: codprograma,
                            nombreprograma: nombreprograma,
                            nivelformativo: "Técnico"
                        },
                        dataType: 'json',
                        beforeSend: function () { notificaciontoast('warning', "Procesando registro", 'Mensaje!') },
                        success: function (data) {
                            if (data.status == true) {
                                notificaciontoast('info', data.mensaje, 'Éxito!')
                                tabletec.ajax.reload();
                                $("#modalcatalogoprogramastec").modal("hide");
                            } else {
                                notificaciontoast('error', data.mensaje.text_codigo_programa_name[0], 'Error!')
                            }
                        },
                        error: function (error) {
                            console.log('Error', error)
                        }
                    })

                } else {
                    console.log("Cancelado");
                }
            });

    })
    //   // FIN


    $('#datatableGeneral_tecnico tbody').on('click', '.deleteBtn', function (e) {
        let id = $(this).attr("data-idprograma");
        confirmation_sweetAlert("Deseas continuar?", "Se procederá a eliminar el programa selecionado", "warning")
            .then(function (isConfirm) {
                if (isConfirm.value) {
                    $.ajax({
                        headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
                        type: 'DELETE',
                        url: '/delete-programas/' + id,
                        beforeSend: function () { notificaciontoast('warning', "procesando eliminar registro", 'Mensaje!') },
                        success: function (data) {
                            if (data.status == true) {
                                notificaciontoast('info', data.mensaje, 'Éxito!')
                                tabletec.ajax.reload();
                            } else {
                                notificaciontoast('error', data.mensaje, 'Error!')
                            }
                        },
                        error: function (error) {
                            console.log('Error', error)
                        }
                    })

                } else {
                    console.log("Cancelado");
                }
            });

    })

})
