
// listar programas
export function cb_programs(elementId='txt-programs') {
    const elementItem = $(`#${elementId}`)
    elementItem.find("option").remove().end() // delete options
    $.ajax({
        type: "GET",
        url: '/ajax_all/programs',
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            elementItem.append('<option selected disabled value="">Seleccione programa</option>');
            response.forEach((elemento) => {
                elementItem.append('<option ' +
                    'value="' + elemento.id + '"' +
                    'data-codprograma="' + elemento.codprograma + '"' +
                    'data-nombre="' + elemento.nombre + '"' +
                    'data-nivel_formativo="' + elemento.nivel_formativo + '"' +
                    ' >' + elemento.nombre + '</option>');
            })
            elementItem.selectpicker("refresh");
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}



// listar planes
export function cb_plans(idprogram) {
    $("#txt-plans").find("option").remove().end() // delete options
    $.ajax({
        type: "GET",
        url: '/ajax_all/plans/' + idprogram,
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            $("#txt-plans").append('<option selected disabled value="">Seleccione plan</option>');
            response.forEach((elemento) => {
                $("#txt-plans").append('<option ' +
                    ' value="' + elemento.id + '"' +
                    ' data-nombre="' + elemento.nombre + '"' +
                    ' data-tipo="' + elemento.tipo + '"' +
                    ' data-modalidad="' + elemento.modalidad + '"' +
                    ' data-enfoque="' + elemento.enfoque + '"' +
                    ' >' + elemento.nombre + " - " + elemento.tipo + '</option>');
            })
            $("#txt-plans").selectpicker("refresh");
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}



// listar periodos por plan
function cb_periods(idsemester, idplan) {
    $("#txt-periods").find("option").remove().end() // delete options
    $.ajax({
        type: "GET",
        url: "/ajax_all/periods/" + idsemester + "/" + idplan,
        dataType: 'json',
        beforeSend: function () { },
        success: function (response) {
            $("#txt-periods").append('<option selected disabled value="">Seleccione periodo</option>');
            response.forEach((elemento) => {
                $("#txt-periods").append('<option' +
                    ' value="' + elemento.id + '"' +
                    ' data-numero="' + elemento.numero + '"' +
                    ' >' + integer_to_roman(elemento.numero) + '</option>');
            })
            $("#txt-periods").selectpicker("refresh");
        },
        error: function (error) {
            console.log("Error", error);
        },
    });
}



const integer_to_roman = (num) => {
    if (typeof num !== 'number')
        return false;

    var digits = String(+num).split(""),
        key = ["", "C", "CC", "CCC", "CD", "D", "DC", "DCC", "DCCC", "CM",
            "", "X", "XX", "XXX", "XL", "L", "LX", "LXX", "LXXX", "XC",
            "", "I", "II", "III", "IV", "V", "VI", "VII", "VIII", "IX"],
        roman_num = "",
        i = 3;
    while (i--)
        roman_num = (key[+digits.pop() + (i * 10)] || "") + roman_num;
    return Array(+digits.join("") + 1).join("M") + roman_num;
};


