import { notificaciontoast } from "../common/method_toast.js";
import { confirmation_sweetAlert } from "../common/method_sweetAlert.js";
import { getButtonsSchema, languageSchema } from "../common/schemas.js";

$(document).ready(function () {

    const tableName = "Ofertas Laborales";

    // LISTAR DATATABLE
    var table = $('#datatableGeneral').DataTable({
        createdRow: function (row, data, index) {
            $(row).addClass("selected");
        },
        order: [],
        ajax: {
            headers: { 'X-CSRF-TOKEN': $('input[name="_token"]').val() },
            type: 'POST',
            url: '/docente/bolsa_laboral/ofertas_laborales/list',
        },
        searching: true,
        dom: "Bfrtip",
        select: false,
        lengthChange: false,
        responsive: true,
        language: languageSchema,
        buttons: getButtonsSchema(tableName),
        columns: [
            { data: 'idjob', className: 'text-center' },
            { data: 'nombrecompany', className: 'text-center' },
            { data: 'nombrecategory', className: 'text-center' },
            { data: 'puesto', className: 'text-center' },
            { data: 'vacantes', className: 'text-center' },
            { data: "fechas", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.fecpublicacion + " - " + all.feccierre;
                },
            },
            { data: "rango_salarial", className: "text-center",
                render: function (data, type, all, meta) {
                    return all.salariomin + " - " + all.salariomax;
                },
            },
            { data: "idjob", className: "text-center", sortable: false,
                render: function (data, type, all, meta) {
                    return `
                        <div class="d-flex justify-content-center">
                            <a href="javascript:void(0);" class="detailBtn btn btn-dark shadow btn-xs sharp"
                            data-idjob="${all.idjob}"
                            data-puesto="${all.puesto}"
                            data-vacantes="${all.vacantes}"
                            data-tipo="${all.tipo}"
                            data-modalidad="${all.modalidad}"
                            data-experiencia="${all.experiencia}"
                            data-fecpublicacion="${all.fecpublicacion}"
                            data-feccierre="${all.feccierre}"
                            data-salariomin="${all.salariomin}"
                            data-salariomax="${all.salariomax}"
                            data-nivel_educativo="${all.nivel_educativo}"
                            data-descripcion="${all.descripcion}"
                            data-estado="${all.estado}"
                            data-idcompany="${all.idcompany}"
                            data-nombrecompany="${all.nombrecompany}"
                            data-idcategory="${all.idcategory}"
                            data-nombrecategory="${all.nombrecategory}"
                            data-idubigeo="${all.idubigeo}"
                            data-iddepartamento="${all.iddepartamento}"
                            data-departamento="${all.departamento}"
                            data-idprovincia="${all.idprovincia}"
                            data-provincia="${all.provincia}"
                            data-iddistrito="${all.iddistrito}"
                            data-distrito="${all.distrito}"
                            data-bs-placement="top"
                            title="Ver Detalle de Servicio registro">
                            <i class="fas fa-eye"></i>
                            </a>
                        </div>
                    `;
                },
            },
            // { data: "estado", className: "text-center",
            //     render: function (data, type, all, meta) {
            //         if (all.estado == "1") {
            //             return `<span class="badge light badge-success">Activo</span>`;
            //         } else {
            //             return `<span class="badge light badge-danger">Inactivo</span>`;
            //         }
            //     },
            // },
        ]
    });

    // Agregar una columna de números automáticos
    table.on('order.dt search.dt', function () {
        table.column(0, { search: 'applied', order: 'applied' }).nodes().each(function (cell, i) {
            cell.innerHTML = i + 1;
        });
    }).draw();

    var valbtn, formCheck, formModal;

    // DETAIL MODAL
    $("#datatableGeneral tbody").on("click", ".detailBtn", function (e) {
        cleardetails();
        // Establecer datos

        $("#txt_1").val($(this).data("nombrecompany"));
        $("#txt_2").val($(this).data("nombrecategory"));
        $("#txt_3").val($(this).data("puesto"));
        $("#txt_4").val($(this).data("vacantes"));
        $("#txt_5").val($(this).data("tipo"));
        $("#txt_6").val($(this).data("modalidad"));
        $("#txt_7").val($(this).data("experiencia"));
        $("#txt_8").val($(this).data("nivel_educativo"));
        $("#txt_9").val($(this).data("fecpublicacion"));
        $("#txt_10").val($(this).data("feccierre"));
        $("#txt_11").val($(this).data("salariomin"));
        $("#txt_12").val($(this).data("salariomax"));
        $("#txt_13").val($(this).data("estado"));
        $("#txt_14").val($(this).data("departamento"));
        $("#txt_15").val($(this).data("provincia"));
        $("#txt_16").val($(this).data("distrito"));
        // $("#txt_17").val($(this).data("descripcion"));
        tinymce.get("txt_17").setContent($(this).data("descripcion"));
        // tinymce.get("txt_17").setMode("readonly");
        // ocultar div
        $("#div-dt-customer_id").css("display", "none");
        $("#dt-customer_id").removeAttr("required");  // para poder pasar el check validity

        $("#modalDetail").modal("show");  // mostrar el formulario
    });


    function cleardetails() {
        $("#txt_1").val("");
        $("#txt_2").val("");
        $("#txt_3").val("");
        $("#txt_4").val("");
        $("#txt_5").val("");
        $("#txt_6").val("");
        $("#txt_7").val("");
        $("#txt_8").val("");
        $("#txt_9").val("");
        $("#txt_10").val("");
        $("#txt_11").val("");
        $("#txt_12").val("");
        $("#txt_13").val("");
        $("#txt_14").val("");
        $("#txt_15").val("");
        $("#txt_16").val("");
        $("#txt_17").val("");
    }

});


