<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Informe de Postulaciones</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            informe de Postulaciones
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <div class="col-xl-12">
                        <div class="row">
                            {{-- <div class="col-xl-3 col-xxl-4 col-lg-4 col-sm-6 col-12 my-2"> --}}
                            <div class="row col-xl-12">
                                <!-- FILTRO -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-companies" class="form-label text-primary"><b><h4>Seleccione una Empresa</h4></b></label>
                                    <select id="txt-companies" name="txt-companies" class="form-control form-control-sm"
                                        data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                                <!-- FILTRO -->
                                <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                    <label for="txt-categories" class="form-label text-primary"><b><h4>Seleccione una Categoria</h4></b></label>
                                    <select id="txt-categories" name="txt-categories"
                                        class="form-control form-control-sm" data-live-search="true" required>
                                        <!-- combobox -->
                                    </select>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <!-- Column starts -->
                            <div class="col-xl-12">
                                <div class="card" id="accordion-three">
                                    <div class="card-header flex-wrap px-3">
                                        <div>
                                            <h4 class="card-title">Registro de información sobre postulaciones</h4>
                                        </div>
                                    </div>
                                    <!-- /tab-content -->
                                    <div class="tab-content" id="myTabContent-2">
                                        <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                            aria-labelledby="home-tab-2">
                                            <div class="card-body p-4">
                                                <div class="table-responsive">
                                                    <table id="datatableGeneral"
                                                        class="table table-hover table-bordered table-sm display rounded-3"
                                                        style="min-width:100%">
                                                        <thead class="thead-primary">
                                                            <tr>
                                                                <th class="text-center">#</th>
                                                                <th class="text-center">Empresa</th>
                                                                <th class="text-center">Puesto</th>
                                                                <th class="text-center">Postulante</th>
                                                                <th class="text-center">Correo</th>
                                                                <th class="text-center">Celular</th>
                                                                <th class="text-center">Fecha Postulación</th>
                                                                <th class="text-center">Estado</th>
                                                                <th class="text-center">Acciones</th>
                                                            </tr>
                                                        </thead>
                                                        <tbody>
                                                            <!--  -->
                                                        </tbody>
                                                    </table>
                                                </div>
                                            </div>
                                        </div>
                                    </div>

                                    <!-- /tab-content -->
                                </div>
                            </div>
                            <!-- Column ends -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <!-- Modal -->
    <form id="formModal" novalidate>
        @csrf
        <div id="modalFeedback" class="modal fade" tabindex="-1" aria-labelledby="modalFeedbackLabel"
            aria-hidden="true">
            <div class="modal-dialog modal-dialog-center modal-lg">
                <div class="modal-content">
                    <!-- header -->
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="modalFeedbackLabel">Feedback</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <!-- body -->
                    <div class="modal-body py-3">
                        <div class="row">
                            <div class="row col-xl-12">
                                <!-- data -->
                                <input type="hidden" id="txt-idjobapplication" name="txt-idjobapplication">
                                <!-- data -->
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-feedback" class="form-label text-primary">Comentario</label>
                                    <input id="txt-feedback" name="txt-feedback" type="text"
                                        class="form-control form-control-sm" required>
                                    @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                </div>
                                <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                    <label for="txt-feedback" class="form-label text-primary">Comentarios
                                        Predeterminados</label>
                                    <div id="div-feedback-aprobar">
                                        <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                            value="¡Tu CV es de nuestro agrado, nos pondremos en contacto!">
                                        <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                            value="¡Requerimos una entrevista presencial, nos pondremos en contacto!">
                                    </div>
                                    <div id="div-feedback-rechazar">
                                    <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                        value="¡Apreciamos tu interés, pero tu CV no ha sido seleccionado en esta ocasión!">
                                    <input type="button" class="feedback-predeterminado form-control form-control-sm mb-1"
                                        value="¡Agradecemos tu participación y te animamos a seguir buscando oportunidades!">
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                            data-bs-dismiss="modal">Cerrar</button>
                        <button id="btnAprobarRechazar" type="button" class="btn btn-primary btn-sm ">Confirmar</button>
                    </div>
                </div>
            </div>
        </div>
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    <script src="{{ asset('/js_Ajax_login/js_Script_Ajax_logout.js') }}"></script>
    <script src="{{ asset('js_combobox/jpcompanies.js') }}"></script>
    <script src="{{ asset('js_combobox/jpcategories.js') }}"></script>


    <!--  Page JS -->
    <script src="{{ asset('js_Ajax_admin/postulaciones.js') }}" type="module"></script>

</body>

</html>
