<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Gestionar Docentes</title>

    @include('include.datatable-styles')

    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">
    {{--     --}}

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
        Gestionar Docentes
        @endsection

        @include('include.sidebar')


        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <!-- row -->
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    <form id="form" name="form">
                        <input type="hidden" id="id_regist_admisions" name="id_regist_admisions_name" value="8">
                        @csrf
                        <div class="col-xl-12">
                            <div class="row">
                                <div class="col-xl-12 col-xxl-12 col-lg-12">
                                    <div class="card">
                                        <div class="card-body p-0">
                                            <div class="email-right-box">
                                                <div role="toolbar" class="toolbar  bg">
                                                    <div class="saprat">
                                                        <div class="d-flex align-items-center">
                                                            <ul class="nav nav-pills  " id="pills-tab" role="tablist">
                                                                <li class="nav-item btn-group" role="presentation">
                                                                    <button class="btn effect mx-2 nav-link active"
                                                                        id="pills-home-tab" data-bs-toggle="pill"
                                                                        data-bs-target="#pills-home" type="button"
                                                                        role="tab" aria-controls="pills-home"
                                                                        aria-selected="true">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            height="1em"
                                                                            viewBox="0 0 448 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                                                            <path
                                                                                d="M219.3 .5c3.1-.6 6.3-.6 9.4 0l200 40C439.9 42.7 448 52.6 448 64s-8.1 21.3-19.3 23.5L352 102.9V160c0 70.7-57.3 128-128 128s-128-57.3-128-128V102.9L48 93.3v65.1l15.7 78.4c.9 4.7-.3 9.6-3.3 13.3s-7.6 5.9-12.4 5.9H16c-4.8 0-9.3-2.1-12.4-5.9s-4.3-8.6-3.3-13.3L16 158.4V86.6C6.5 83.3 0 74.3 0 64C0 52.6 8.1 42.7 19.3 40.5l200-40zM111.9 327.7c10.5-3.4 21.8 .4 29.4 8.5l71 75.5c6.3 6.7 17 6.7 23.3 0l71-75.5c7.6-8.1 18.9-11.9 29.4-8.5C401 348.6 448 409.4 448 481.3c0 17-13.8 30.7-30.7 30.7H30.7C13.8 512 0 498.2 0 481.3c0-71.9 47-132.7 111.9-153.6z" />
                                                                        </svg>
                                                                        Docentes
                                                                    </button>
                                                                </li>
                                                                <li class="nav-item btn-group" role="presentation"
                                                                    id="modulemasive">
                                                                    <button class="btn  mx-2 effect nav-link"
                                                                        id="pills-profile-tab" data-bs-toggle="pill"
                                                                        data-bs-target="#pills-profile" type="button"
                                                                        role="tab" aria-controls="pills-profile"
                                                                        aria-selected="false">
                                                                        <svg xmlns="http://www.w3.org/2000/svg"
                                                                            height="1em"
                                                                            viewBox="0 0 640 512"><!--! Font Awesome Free 6.4.2 by @fontawesome - https://fontawesome.com License - https://fontawesome.com/license (Commercial License) Copyright 2023 Fonticons, Inc. -->
                                                                            <path
                                                                                d="M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128H144zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39V392c0 13.3 10.7 24 24 24s24-10.7 24-24V257.9l39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z" />
                                                                        </svg>
                                                                        Carga masiva
                                                                    </button>
                                                                </li>
                                                            </ul>
                                                        </div>
                                                        <div class="btn-group text-center mx-2">
                                                            <button type="button" id="btn_download_pantilla"
                                                                data-toggle="tooltip" data-placement="top"
                                                                title="Descargar plantilla de resgitro masiva"
                                                                class="btn btn-success btn-sm"><i
                                                                    class="fa-solid fa-file-excel"></i> Descargar
                                                                Excel</button>
                                                            {{-- <button type="button" id="btnCreateModal"
                                                                data-toggle="modal" data-placement="top"
                                                                title="Agregar nuevo Estudiante"
                                                                class="btn btn-primary btn-sm"  data-bs-target="#modalCreateUpdate"><i
                                                                    class="fa-solid fa-user-plus"></i> Agregar Docente</button> --}}
                                                        </div>
                                                    </div>
                                                </div>
                                                <div class="tab-content my-3" id="pills-tabContent">
                                                    <div class="tab-pane fade  show active px-3 mt-3" id="pills-home"
                                                        role="tabpanel" aria-labelledby="pills-home-tab">
                                                        <div class="card-header flex-wrap px-3">
                                                            <div>
                                                                <h4 class="card-title">Registro de información sobre Docentes</h4>
                                                            </div>
                                                            <button id="btnCreateModal" type="button" class="btn btn-primary btn-sm"
                                                                data-bs-toggle="modal" data-bs-target="#modalCreateUpdate">
                                                                + Nuevo Docente
                                                            </button>
                                                        </div>
                                                        <!-- /tab-content -->
                                                        <div class="tab-content" id="myTabContent-2">
                                                            <div class="tab-pane fade show active" id="withoutSpace"
                                                                Aulae="tabpanel" aria-labelledby="home-tab-2">
                                                                <div class="table-responsive">
                                                                    <table id="datatableGeneral"
                                                                        class="table table-bordered table-sm display rounded-3"
                                                                        style="min-width:100%">
                                                                        <thead class="thead-primary">
                                                                            <tr>
                                                                                <th class="text-center">Tipo ID</th>
                                                                                <th class="text-center"># ID</th>
                                                                                <th class="text-center">Apellidos</th>
                                                                                <th class="text-center">Nombres</th>
                                                                                <th class="text-center">Tipo de Contrato</th>
                                                                                <th class="text-center">Horas Lectivas</th>
                                                                                <th class="text-center">Horas No Lectivas</th>
                                                                                <th class="text-center">Acceso</th>
                                                                                <th class="text-center">Acciones</th>
                                                                            </tr>
                                                                        </thead>
                                                                        <tbody>
                                                                            <!--  -->
                                                                        </tbody>
                                                                    </table>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                                        aria-labelledby="pills-profile-tab">
                                                        <div class="col-xl-12">
                                                            <div class="card" id="accordion-three">
                                                                <div class="card-header  m-0 px-3">
                                                                    <div
                                                                        class="col-xl-5 col-md-6 col-sm-12 col-12 p-0 mt-2">
                                                                        <div class="input-group">
                                                                            <input class="form-control form-control-sm"
                                                                                id="file_select_plantilla"
                                                                                type="file" required>
                                                                            <div class="invalid-feedback">
                                                                                Ingrese un código.
                                                                            </div>
                                                                            <button class="btn btn-warning btn-sm"
                                                                                type="button" disabled
                                                                                id="btn_previsualizar_plantilla"><i
                                                                                    class="fa-solid fa-magnifying-glass fa-beat-fade"></i>
                                                                                Previsualizar</button>
                                                                        </div>
                                                                    </div>
                                                                    <div
                                                                        class="col-xl-auto col-md-6 col-sm-12 col-12 mt-2 mx-2">
                                                                        <div
                                                                            class="row justify-content-center align-items-center">
                                                                            <button type="button"
                                                                                class="btn btn-primary btn-sm"
                                                                                id="btn_insert_plantilla"
                                                                                value="Registrar"><i
                                                                                    class="fa-solid fa-upload fa-beat-fade"></i>
                                                                                Registrar
                                                                            </button>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- /tab-content -->
                                                                <div class="tab-content" id="myTabContent-2">
                                                                    <div class="tab-pane fade show active"
                                                                        id="withoutSpace" role="tabpanel"
                                                                        aria-labelledby="home-tab-2">
                                                                        <div class="card-body px-3 p-4">
                                                                            <div class="table-responsive">
                                                                                <table
                                                                                    id="datatableGeneral_preview_Excel"
                                                                                    class="table table-hover table-bordered table-sm display rounded-3"
                                                                                    style="min-width:100%">
                                                                                    <thead class="thead-primary">
                                                                                        <tr>
                                                                                            <th class="text-center">Tipo doc.</th>
                                                                                            <th class="text-center">Nº doc.</th>
                                                                                            <th class="text-center">Password</th>
                                                                                            <th class="text-center">Nombres</th>
                                                                                            <th class="text-center">Apellido pa.</th>
                                                                                            <th class="text-center">Apellidos ma.</th>
                                                                                            <th class="text-center">Fecha nac.</th>
                                                                                            <th class="text-center">Tipo de Docente</th>
                                                                                            <th class="text-center">Tipo de Contrato</th>
                                                                                            <th class="text-center">Horas Lectivas</th>
                                                                                            <th class="text-center">Horas No Lectivas</th>
                                                                                            <th class="text-center">Correo</th>
                                                                                            <th class="text-center">Teléfono</th>
                                                                                            <th class="text-center">Celular</th>
                                                                                            <th class="text-center">Dirección</th>
                                                                                            <th class="text-center">Género</th>
                                                                                        </tr>
                                                                                    </thead>
                                                                                    <tbody>
                                                                                        <!--  -->
                                                                                    </tbody>
                                                                                </table>
                                                                            </div>
                                                                        </div>
                                                                    </div>
                                                                </div>
                                                                <!-- /tab-content -->
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        <div class="form-validation">

            <!-- Modal -->
            <form id="formModal" class="needs-validation" novalidate>
                @csrf
                <div id="modalCreateUpdate" class="modal fade" tabindex="-1" aria-labelledby="modalCreateUpdateLabel"
                    aria-hidden="true">
                    <div class="modal-dialog modal-dialog-center modal-xl">
                        <div class="modal-content">
                            <!-- header -->
                            <div class="modal-header">
                                <h1 class="modal-title fs-5" id="modalCreateUpdateLabel">Registrar nuevo Docente</h1>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                            </div>
                            <!-- body -->
                            <div class="modal-body">
                                <div class="row">
                                    <div class="row col-xl-12">
                                        <!-- data -->
                                        <input id="txt_iduser" name="txt_iduser" type="hidden">
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt-identificationtype" class="form-label text-primary">Tipo de ID</label>
                                            <select id="txt-identificationtype" name="txt-identificationtype"
                                                class="default-select  form-control form-control-sm" required>
                                                <!-- combobox -->
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_nroidenti" class="form-label text-primary"># Identificación</label>
                                            <div class="input-group">
                                                <input id="txt_nroidenti" name="txt_nroidenti" type="number" autocomplete="off"
                                                class="form-control form-control-sm" placeholder="12345678" required>
                                                <a class="input-group-text bg-primary text-white btn btn-sm rounded-pill" href="javascript:void(0);" id="btn-querybd" data-bs-placement="top" title="Consultar usuario existente"> <i class="fa fa-search"></i> </a>
                                                <a class="input-group-text bg-info text-white btn btn-sm rounded-pill" href="javascript:void(0);" id="btn-querydata" data-bs-placement="top" title="Consultar RENIEC"> <i class="fa fa-search"></i> </a>
                                                @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_nombres" class="form-label text-primary">Nombres</label>
                                            <input id="txt_nombres" name="txt_nombres" type="text" autocomplete="off"
                                                class="form-control form-control-sm text-capitalize" placeholder="Ingrese nombres" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_apellido_pa" class="form-label text-primary">Apellido paterno</label>
                                            <input id="txt_apellido_pa" name="txt_apellido_pa" type="text" autocomplete="off"
                                                class="form-control form-control-sm text-capitalize" placeholder="Ingrese apellido paterno"
                                                required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_apellido_ma" class="form-label text-primary">Apellido materno</label>
                                            <input id="txt_apellido_ma" name="txt_apellido_ma" type="text" autocomplete="off"
                                                class="form-control form-control-sm text-capitalize" placeholder="Ingrese apellido materno"
                                                required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div id="div_txt_password" class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_password" class="form-label text-primary">Contraseña</label>
                                            <input id="txt_password" name="txt_password" type="password"
                                                class="form-control form-control-sm" placeholder="********" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_acceso" class="form-label text-primary">Acceso</label>
                                            <select id="txt_acceso" name="txt_acceso"
                                                class="default-select form-control form-control-sm" required>
                                                <!-- combobox -->
                                                @include('include.combobox.bit')
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_fecnac" class="form-label text-primary">Fecha de Nacimiento</label>
                                            <input id="txt_fecnac" name="txt_fecnac" type="date"
                                                class="form-control form-control-sm" placeholder="" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt-teachertypes" class="form-label text-primary">Tipo de docente</label>
                                            <select id="txt-teachertypes" name="txt-teachertypes" class="default-select form-control form-control-sm" required>
                                                <!-- combobox -->
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_tipocontrato" class="form-label text-primary">Tipo de Contrato</label>
                                            <select id="txt_tipocontrato" name="txt_tipocontrato"
                                                class="default-select form-control form-control-sm" required>
                                                <!-- combobox -->
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_estado" class="form-label text-primary">Estado</label>
                                            <select id="txt_estado" name="txt_estado"
                                                class="default-select form-control form-control-sm" required>
                                                <!-- combobox -->
                                                <option selected value="1">Contratado</option>
                                                <option value="0">Sin Contrato</option>
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_correo" class="form-label text-primary">Correo Electrónico</label>
                                            <input id="txt_correo" name="txt_correo" type="email" autocomplete="off"
                                                class="form-control form-control-sm" placeholder="example@email.com" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_telefono" class="form-label text-primary">Teléfono</label>
                                            <input id="txt_telefono" name="txt_telefono" type="text" autocomplete="off"
                                            onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                            class="form-control form-control-sm" placeholder="357-2984">
                                            {{-- @include('include.div.invalid-feedback')  --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_celular" class="form-label text-primary">Celular</label>
                                            <input id="txt_celular" name="txt_celular" type="text" autocomplete="off"
                                            onkeypress='return event.charCode >= 48 && event.charCode <= 57'
                                            class="form-control form-control-sm" placeholder="967-542-321" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_genre_id" class="form-label text-primary">Género</label>
                                            <select id="txt_genre_id" name="txt_genre_id"
                                                class="default-select form-control form-control-sm" required>
                                                <!-- combobox -->
                                                @include('include.combobox.genre')
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_departamento" class="form-label text-primary">Departamento</label>
                                            <select id="txt_departamento" name="txt_departamento"
                                                class="form-control form-control-sm" data-live-search="true" required>
                                                <!-- combobox -->
                                                @include('include.combobox.departamento')
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_provincia" class="form-label text-primary">Provincia</label>
                                            <select id="txt_provincia" name="txt_provincia"
                                                class="form-control form-control-sm" data-live-search="true" required>
                                                <!-- combobox dinamico -->
                                                <option selected disabled value="">Seleccione opción</option>
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-3 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_distrito" class="form-label text-primary">Distrito</label>
                                            <select id="txt_distrito" name="txt_distrito"
                                                class="form-control form-control-sm" data-live-search="true" required>
                                                <!-- combobox dinamico -->
                                                <option selected disabled value="">Seleccione opción</option>
                                            </select>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-6 col-md-6 col-sm-6 col-12 mb-3">
                                            <label for="txt_direccion" class="form-label text-primary">Dirección</label>
                                            <input id="txt_direccion" name="txt_direccion" type="text" autocomplete="off"
                                                class="form-control form-control-sm" maxlength="200"
                                                placeholder="Ejemplo: URB. SANTO DOMINGO ETAPA X MZ. M LT. 2" required>
                                            @include('include.div.invalid-feedback') {{-- mensaje de error campo vacio --}}
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <!-- footer -->
                            <div class="modal-footer">
                                <button id="btnCloseModal" type="button" class="btn btn-danger  btn-sm light"
                                    data-bs-dismiss="modal">Cerrar</button>
                                <button id="btnCreateUpdate" type="button" class="btn btn-primary btn-sm ">Guardar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>


            <form id="formModal2" novalidate>
                @csrf
                <div id="modalUpdatePassword" class="modal fade" tabindex="-1"
                    aria-labelledby="modalUpdatePasswordLabel" aria-hidden="true">
                    <div class="modal-dialog modal-dialog-center modal-xs">
                        <div class="modal-content">
                            <div class="modal-header">
                                <h1 class="modal-title fs-5" id="modalUpdatePasswordLabel">Actualizar Contraseña</h1>
                                <button type="button" class="btn-close" data-bs-dismiss="modal"
                                    aria-label="Close"></button>
                            </div>
                            <div class="modal-body">
                                <div class="row">
                                    <div class="row col-xl-12">
                                        <!-- data -->
                                        <input id="txt_iduser2" name="txt_iduser2" type="hidden">
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <label for="txt_nroidenti2" class="form-label text-primary">#
                                                Identificación</label>
                                            <input id="txt_nroidenti2" name="txt_nroidenti2" type="text"
                                                class="form-control form-control-sm" required>
                                            <div class="invalid-feedback">
                                                Requiere un numero de identificación
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <label for="txt_apenom" class="form-label text-primary">Apellidos y
                                                Nombres</label>
                                            <input id="txt_apenom" name="txt_apenom" type="text"
                                                class="form-control form-control-sm" required>
                                            <div class="invalid-feedback">
                                                Requiere Ingresa un nombre.
                                            </div>
                                        </div>
                                        <!-- data -->
                                        <div class="col-xl-12 col-md-12 col-sm-12 col-12 mb-3">
                                            <label for="txt_password2"
                                                class="form-label text-primary">Contraseña</label>
                                            <input id="txt_password2" name="txt_password2" type="password"
                                                class="form-control form-control-sm" placeholder="********" required>
                                            <div class="invalid-feedback">
                                                Ingrese una contraseña
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="modal-footer">
                                <button type="button" class="btn btn-danger  btn-sm light"
                                    data-bs-dismiss="modal">Cerrar</button>
                                <button id="btnUpdatePassword" type="button"
                                    class="btn btn-primary btn-sm ">Guardar</button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>


            <div id="modalCargandoExcel" class="modal fade" tabindex="-1" aria-labelledby="modalCargandoExcel"
                aria-hidden="true" style="background: rgba(0,0,123,0.4)">
                <div class="modal-dialog modal-dialog-center modal-xl">
                    <div class="modal-content">
                        <!-- body -->
                        <div class="modal-body">
                            <div class="row">
                                <input type="hidden" value="0" id="hiddenswitch">
                                <div class="col-xl-12 text-primary mx-2">
                                    <h1 class="modal-title fs-5" id="id_preload_excel"></h1>
                                </div>
                                <div class="col-xl-12" id="div_progressbar_modal_preload">

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')

    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>

    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
        var route_download = '{{ route('inscripcion.teachers.plantilla.download') }}';
    </script>
    <script src="{{ asset('/js_Ajax_login/js_Script_Ajax_logout.js') }}"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.16.9/xlsx.full.min.js"></script>

    {{-- <script src="{{ asset('/js_Ajax_admin/js_Script_Ajax_inscripcion_donwload_plantilla.js') }}" type="module"></script> --}}
    <script src="{{ asset('/js_Ajax_admin/js_Script_Ajax_inscripcion_docentes.js') }}" type="module"></script>

    <script src="{{ asset('js_combobox/ubigeo.js') }}"></script>
    <script src="{{ asset('js_combobox/teachercontracttypes.js') }}"></script>
    <script src="{{ asset('js_combobox/teachertypes.js') }}"></script>
    <script src="{{ asset('js_combobox/identificationtypes.js') }}"></script>
</body>

</html>
