<!DOCTYPE html>
<html lang="es">

<head>

    @include('include.meta-favicon')

    @include('include.plugins-styles')

    <!-- Page Title Here -->
    <title>Inicio docente</title>
    @include('include.datatable-styles')
    <!-- Template CSS -->
    <link href="https://fonts.googleapis.com/css2?family=Material+Icons" rel="stylesheet">
    <link href="{{ asset('/css/style.css') }}" rel="stylesheet">

</head>

<body>

    @include('include.preloader')

    <!--**********************************
        Main wrapper start
    ***********************************-->
    <div id="main-wrapper">

        @include('include.nav_header')

        @extends('include.header')
        @section('titlenavbar')
            {{ __('Inicio') }}
        @endsection

        @include('include.sidebar')

        <!--**********************************
            Content body start
        ***********************************-->
        <div class="content-body">
            <div class="container-fluid">
                <!-- Row -->
                <div class="row">
                    @csrf
                    <div class="col-xl-8">
                        <div class="card h-auto">
                            <div class="card-header p-0">
                                <div class="user-bg w-100">
                                    <div class="user-svg">
                                        <svg width="264" height="109" viewBox="0 0 264 109" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect x="0.0107422" y="0.6521" width="263.592" height="275.13"
                                                rx="20" fill="#FCC43E" />
                                        </svg>
                                    </div>
                                    <div class="user-svg-1">
                                        <svg width="264" height="59" viewBox="0 0 264 59" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <rect y="0.564056" width="263.592" height="275.13" rx="20"
                                                fill="#FB7D5B" />
                                        </svg>
                                    </div>
                                </div>
                            </div>
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div class="user">
                                        <div class="user-media">
                                            @if (Auth::User()->genre_id == 1)
                                                <img class="img_user avatar avatar-xxl" src="{{ asset('/images/avatar/male.jpg') }}"
                                                    alt="">
                                            @elseif (Auth::User()->genre_id == 2)
                                                <img class="img_user avatar avatar-xxl" src="{{ asset('/images/avatar/female.jpg') }}"
                                                    alt="">
                                            @else
                                                <img class="img_user avatar avatar-xxl" src="{{ asset('/images/avatar/other.jpg') }}"
                                                    alt="">
                                            @endif

                                        </div>
                                        <div>
                                            <h2 class="mb-0">{{ Auth::User()->nombres }}</h2>
                                            <p class="text-primary font-w600">Docente</p>
                                        </div>
                                    </div>
                                    @php
                                        $user = Auth::user();
                                        $teacherData = $user->teachers;
                                    @endphp

                                    <div class="row m-0 justify-content-center align-items-center">
                                        @if ($teacherData)
                                            <p class="text-primary p-0">
                                                <a class="timeline-panel text-muted text-left" href="#">
                                                    <h4 class="mb-0">Detalle</h4>
                                                    <p class="mb-0">Tipo contrato: {{ $teacherData[0]->tipocontrato }}
                                                    </p>
                                                    <h6 class="mb-0">Código: <strong class="text-primary"></strong>
                                                    </h6>
                                                    <span><strong class="text-primary"> Horas lectivas:
                                                            {{ $teacherData[0]->horas_lectivas }}</strong></span><br>
                                                    <span><strong class="text-primary"> Horas no lectivas:
                                                            {{ $teacherData[0]->horas_nolectivas }} </strong></span>
                                                </a>
                                            </p>
                                        @endif

                                    </div>

                                </div>
                                <div class="row mt-2">
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/profile.svg') }}" alt="">
                                                </a>
                                            </li>
                                            <li>
                                                <span>Apellidos:</span>
                                                <h5 class="mb-0">{{ Auth::User()->nombres }}
                                                    {{ Auth::User()->apellido_pa }} - {{ Auth::User()->apellido_ma }}
                                                </h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/svg/location.svg') }}" alt="">
                                                </a>

                                            </li>
                                            <li><span>Dirección:</span>
                                                <h5 class="mb-0">{{ Auth::User()->direccion }}</h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/svg/phone.svg') }}" alt="">
                                                </a>
                                            </li>
                                            <li><span>Celular:</span>
                                                <h5 class="mb-0">{{ Auth::User()->celular }} -
                                                    {{ Auth::User()->telefono }}</h5>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="col-xxl-6 col-xl-6 col-lg-6 col-sm-6 my-1">
                                        <ul class="student-details">
                                            <li class="me-2">
                                                <a class="icon-box bg-secondary">
                                                    <img src="{{ asset('/images/svg/email.svg') }}" alt="">
                                                </a>

                                            </li>
                                            <li><span>Correo:</span>
                                                <h5 class="mb-0">{{ Auth::User()->correo }}</h5>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-4">
                        <div class="card">
                            <div class="card-header border-0 pb-2 justify-content-center bg-primary">
                                <h4 class="card-title text-light">Asignaturas <span id="total_asign"></span></h4>
                            </div>
                            <div class="card-body p-0">
                                <div id="DZ_W_TimeLine11"
                                    class="widget-timeline dlab-scroll height500 style-1 my-4 px-2">
                                    <ul class="timeline" id="list_asignaturas">

                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-xl-12 col-lg-12 col-md-12 col-12 col-sm-12">
                        <div class="card" id="accordion-three">
                            <div class="card-header flex-wrap px-3">
                                <div>
                                    <h4 class="card-title">Registro de información de los alumnos matriculado por asignatura
                                    </h4>
                                </div>
                                <div class="d-flex align-items-center justify-content-center" style="width: 30rem">
                                    <div class="input-group">
                                        <select id="cb-curso" name="cb-curso" type="text"
                                            class="form-control form-control-sm">
                                            <option disabled selected value="0">Seleccione asignatura</option>
                                        </select>
                                    </div>
                                </div>
                            </div>
                            <!-- /tab-content -->
                            <div class="tab-content" id="myTabContent-2">
                                <div class="tab-pane fade show active" id="withoutSpace" role="tabpanel"
                                        aria-labelledby="home-tab-2">
                                        <div class="card-body p-4">
                                            <div class="table-responsive">
                                                <table id="datatableGeneral"
                                                    class="table table-hover table-bordered table-sm display rounded-3"
                                                    style="min-width:100%">
                                                    <thead class="thead-primary">
                                                        <tr>
                                                            <th class="text-center">Asignatura</th>
                                                            <th class="text-center">N° documento</th>
                                                            <th class="text-center">Estudiante</th>
                                                            <th class="text-center">Apellido Pa</th>
                                                            <th class="text-center">Apellido Ma</th>
                                                            <th class="text-center">Correo</th>
                                                            {{-- <th class="text-center">Nota</th>
                                                            <th class="text-center">Estado</th> --}}
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <!--  -->
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!--**********************************
            Content body end
        ***********************************-->
        @include('include.footer')


    </div>
    <!--**********************************
        Main wrapper end
    ***********************************-->
    <form id="formModal" novalidate>
        @csrf
        <input type="hidden" id="txt-idcourse" name="txt-idcourse">
    </form>

    <!--**********************************
        Scripts
    ***********************************-->

    @include('include.plugins-scripts')

    @include('include.modal-versiones')

    @include('include.datatable-scripts')

    <!-- Template JS -->
    <script src="{{ asset('/js/custom.min.js') }}"></script>
    <script src="{{ asset('/js/dlabnav-init.js') }}"></script>


    <!-- Logout JS -->
    <script>
        var logoutRoute = '{{ route('logout') }}';
    </script>
    <script src="{{ asset('/js_Ajax_login/js_Script_Ajax_logout.js') }}"></script>


    <!--  Page JS -->
    <script src="{{ asset('/js_Ajax_docentes/js_Script_Ajax_HomeDocentes.js') }}" type="module"></script>
    <script src="//cdn.rawgit.com/ashl1/datatables-rowsgroup/v1.0.0/dataTables.rowsGroup.js"></script>

</body>

</html>
