<?php

use App\Http\Controllers\error\ErrorController;
use App\Http\Controllers\tramitedocumentario\TramiteDocumentario;
use App\Http\Controllers\egresados\Datosegresado;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\home\StudenthomeController;
use App\Http\Controllers\home\DocentehomeController;
use App\Http\Controllers\LoginController;
use App\Http\Controllers\admin\ProgramController;
use App\Http\Controllers\admin\UbigeoController;
use App\Http\Controllers\admin\ModuleController;
use App\Http\Controllers\admin\PlanController;
use App\Http\Controllers\admin\StudentController;
use App\Http\Controllers\admin\TeacherController;
use App\Http\Controllers\admin\TeachertypeController;
use App\Http\Controllers\admin\JpcategoryController;
use App\Http\Controllers\admin\JpcompanyController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\JpjobController;
use App\Http\Controllers\admin\IdentificationtypeController;
use App\Http\Controllers\admin\AdministratorProfileController;
use App\Http\Controllers\admin\TeacherProfileController;
use App\Http\Controllers\admin\StudentProfileController;
use App\Http\Controllers\admin\TeachercontracttypeController;

use App\Http\Controllers\alumno\AlumnoAsistenciaController;


include('web/admin.php');


include('web/teacher.php');


include('web/student.php');


include('web/company.php');


// LOGIN
Route::middleware('guest')->group(function () {
    Route::get('/', [LoginController::class, 'index'])->name('login');
    Route::get('/login', [LoginController::class, 'index']);
    Route::post('authenticateLogin', [LoginController::class, 'authenticateLogin'])->name('login.authenticate');
    Route::post('authenticateLoginCompany', [LoginController::class, 'authenticateLoginCompany'])->name('loginCompany.authenticate');
});


// HOME - ADMIN
Route::group(['middleware' => ['checksession', 'checkestado', 'checktypeuser:1,4,5,7']], function () {
    // Aquí van las rutas que requieren autenticación
    Route::get('/admin', [LoginController::class, 'dashboard'])->name('home.adm.dashboard');
});


// HOME - DOCENTES
Route::group(['middleware' => ['checksession', 'checkestado', 'checktypeuser:2,4,6,7']], function () {
    // Aquí van las rutas que requieren autenticación
    Route::get('/docente', [LoginController::class, 'homeDocentes'])->name('home.docente.index');
    Route::get('/docente/dataAsignaturas', [DocentehomeController::class, 'homeDocentesData']);
    Route::post('/docente/list_students', [DocentehomeController::class, 'list_students']);
});


// HOME - ESTUDIANTES
Route::group(['middleware' => ['checksession', 'checkestado', 'checktypeuser:3,5,6,7']], function () {
    // Aquí van las rutas que requieren autenticación
    Route::get('/student', [LoginController::class, 'homeStudent'])->name('home.student.index');
    Route::get('/student/dataAsignaturas', [StudenthomeController::class, 'homeStudentData']);
    Route::get('/student/list_history_cursos', [StudenthomeController::class, 'list_history_cursos']);
});


// NOTIFICACIONES
Route::group(['middleware' => ['checksession', 'checkestado']], function () {
    Route::post('/user/notificacion/update/versiones', [LoginController::class, 'confirmarNotificacionUpdateVersion']);
});


// CERRAR CESIÓN
Route::group(['middleware' => []], function () {
    Route::post('logout', [LoginController::class, 'logout'])->name('logout');
});


// RUTAS PARA DIRECCIONAR A LAS PAGES DE ERRORES
Route::get('/error-403', [ErrorController::class, 'error403'])->name('page.error.403');
Route::get('/module/tramite/error-403', [ErrorController::class, 'inactivoModuloTramite'])->name('page.inactivo.tramite');


// RUTAS PARA EDITAR PERFIL
Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:1,4,5,7']], function () {
    Route::get('/admin/profile', [AdministratorProfileController::class, 'index'])->name('admin.profile');
    Route::get('/admin/profile/data', [AdministratorProfileController::class, 'data']);
    Route::put('/admin/profile/update', [AdministratorProfileController::class, 'update']);
    Route::put('/admin/profile/update_password', [AdministratorProfileController::class, 'update_password']);
});


Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:2,4,6,7']], function () {
    Route::get('/teacher/profile', [TeacherProfileController::class, 'index'])->name('teacher.profile');
    Route::get('/teacher/profile/data', [TeacherProfileController::class, 'data']);
    Route::put('/teacher/profile/update', [TeacherProfileController::class, 'update']);
    Route::put('/teacher/profile/update_password', [TeacherProfileController::class, 'update_password']);
});


Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:3,5,6,7']], function () {
    Route::get('/student/profile', [StudentProfileController::class, 'index'])->name('student.profile');
    Route::get('/student/profile/data', [StudentProfileController::class, 'data']);
    Route::put('/student/profile/update', [StudentProfileController::class, 'update']);
    Route::put('/student/profile/update_password', [StudentProfileController::class, 'update_password']);
});


/* -------------------------- CONSULTAS AJAX_ALL --------------------------*/


// CONSULTAR SIN SESIÓN
Route::get('/ajax_all/identificationtypes', [IdentificationtypeController::class, 'ajax_all']);


// CONSULTAR CON SESIÓN
Route::group(['middleware' => []], function () {
    Route::get('/admin/bolsa_laboral/empresas/query_data/{nroruc}', [JpcompanyController::class, 'query_data']); //Traer Datos del DNI
    Route::post('/solicitud/empresas/store', [JpcompanyController::class, 'storeSolicitud']);
    Route::get('/verTrabajoDocumento/{idjob}', [JpjobController::class, 'verTrabajoDocumento']);
    Route::get('/ajax_all/programs', [ProgramController::class, 'ajax_all'])->name('ajax_all.programs');
    Route::get('/ajax_all/plans/{idprogram}', [PlanController::class, 'ajax_all_by_idprogram']);
    Route::get('/ajax_all/ubigeo/provincias/{departamento}', [UbigeoController::class, 'ajax_all_ubigeo_provincias'])->name('ajax_all.ubigeo.provincias');
    Route::get('/ajax_all/ubigeo/distritos/{provincia}', [UbigeoController::class, 'ajax_all_ubigeo_distritos'])->name('ajax_all.ubigeo.distritos');
    Route::get('/ajax_all/modulos', [ModuleController::class, 'ajax_all'])->name('ajax_all.modulos');
    Route::get('/ajax_all/teachers', [TeacherController::class, 'ajax_all']);
    Route::get('/ajax_all/students/{idplan}', [StudentController::class, 'ajax_all_by_idplan']);
    Route::get('/ajax_all/students', [StudentController::class, 'ajax_all']);
    Route::get('/ajax_all/student/by_idprogram/{idprogram}', [StudentController::class, 'ajax_all_by_idprogram']);
    Route::get('/ajax_all/teachertypes', [TeachertypeController::class, 'ajax_all']);
    Route::get('/ajax_all/users/{nroidenti}', [UserController::class, 'ajax_all_by_nroidenti']);
    Route::get('/ajax_all/companies', [JpcompanyController::class, 'ajax_all']);
    Route::get('/ajax_all/categories', [JpcategoryController::class, 'ajax_all']);
    Route::get('/ajax_all/teachers/subjects', [DocentehomeController::class, 'ajax_all_subjects']);
    Route::get('/ajax_all/teachers/subjectclasses/{idsubject}', [DocentehomeController::class, 'ajax_all_subjectclasses']);
    Route::get('/ajax_all/teachercontracttypes', [TeachercontracttypeController::class, 'ajax_all']);
});

