<?php

use App\Http\Controllers\admin\DownloadExcelplantillaStudentsController;
use App\Http\Controllers\planes\DownloadExcelController;
use App\Http\Controllers\planes\UploadExcelController;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\admin\AdministratorController;
use App\Http\Controllers\admin\ProgramController;
use App\Http\Controllers\admin\PlanController;
use App\Http\Controllers\admin\StudentController;
use App\Http\Controllers\admin\TeacherController;
use App\Http\Controllers\admin\TeachertypeController;
use App\Http\Controllers\admin\ApinetpeController;
use App\Http\Controllers\admin\CategoryTagController;
use App\Http\Controllers\admin\JpcategoryController;
use App\Http\Controllers\admin\JpcompanyController;
use App\Http\Controllers\admin\JpjobapplicationController;
use App\Http\Controllers\admin\JpjobController;
use App\Http\Controllers\admin\JptagController;
use App\Http\Controllers\admin\StudentdocumentController;
use App\Http\Controllers\admin\UserController;
use App\Http\Controllers\admin\IdentificationtypeController;
use App\Http\Controllers\admin\TeachercontracttypeController;
use App\Http\Controllers\FileController;
use App\Http\Controllers\admin\InscripcionesstudentsController;

/* ---------------------------------------------------------------------------------------------------------------------------------- */
/* RUTAS PARA ADMINISTRADORES */
/* ---------------------------------------------------------------------------------------------------------------------------------- */


/* --------------------------
    FUNCIONES ESPECIALES PARA ADMINS
    --------------------------*/

Route::group(['middleware' => ['checksession', 'checkestado', 'checktypeuser:1,4,5,7']], function () {
    // ADMINISTRADORES - INICIO
    Route::get('/admin/query_data/{nroidenti}', [ApinetpeController::class, 'query_data']); //Traer Datos del DNI
    Route::get('/admin/query_bd/{nroidenti}', [UserController::class, 'query_bd']); //Traer Datos del DNI
    // ADMINISTRADORES - FIN

});
/* --------------------------
    FUNCIONES ESPECIALES PARA ADMINS
    --------------------------*/



/* --------------------------
    INICIO - SEGURIDAD
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado', 'checktypeuser:1,4,5,7', 'page_accessroute:1']], function () {
    // ADMINISTRADORES - INICIO
    Route::get('/admin/seguridad/administradores', [AdministratorController::class, 'index'])->name('admin.seguridad.administradores');
    Route::post('/admin/seguridad/administradores/list', [AdministratorController::class, 'list']);
    Route::post('/admin/seguridad/administradores/store', [AdministratorController::class, 'store']);
    Route::put('/admin/seguridad/administradores/update/{id}', [AdministratorController::class, 'update']);
    Route::put('/admin/seguridad/administradores/update_password/{id}', [AdministratorController::class, 'update_password']);
    Route::delete('/admin/seguridad/administradores/destroy/{id}', [AdministratorController::class, 'destroy']);
    // ADMINISTRADORES - FIN
});
/* --------------------------
    FIN - SEGURIDAD
    --------------------------*/


/* --------------------------
    INICIO - INSTITUCION
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:1,4,5,7', 'page_accessroute:2']], function () {

    // PROGRAMAS - INICIO
    Route::get('/admin/institucion/programas', [ProgramController::class, 'index'])->name('admin.institucion.programas');
    Route::get('/admin/institucion/programas/list/proftec', [ProgramController::class, 'listproftec'])->name('admin.institucion.programas.list.prof.tec');
    Route::get('/admin/institucion/programas/list/tec', [ProgramController::class, 'listtec'])->name('admin.institucion.programas.list.tec');
    Route::get('/admin/cargar/catalogo/programas/proftec', [ProgramController::class, 'cargarExcelproftec'])->name('admin.cargar.catalogo.programas.proftec');
    Route::get('/admin/cargar/catalogo/programas/tec', [ProgramController::class, 'cargarExceltec'])->name('admin.cargar.catalogo.programas.tec');
    Route::post('/post-programas', [ProgramController::class, 'store'])->name('admin.institucion.programas.store');
    Route::delete('/delete-programas/{id}', [ProgramController::class, 'destroy'])->name('elementos.eliminar');
    // PROGRAMAS - FIN


    // TIPO DE DOCENTE - INICIO
    Route::get('/admin/institucion/tiposdocente', [TeachertypeController::class, 'index'])->name('admin.institucion.tiposdocente');
    Route::post('/admin/institucion/tiposdocente/list', [TeachertypeController::class, 'list']);
    Route::post('/admin/institucion/tiposdocente/store', [TeachertypeController::class, 'store']);
    Route::put('/admin/institucion/tiposdocente/update/{id}', [TeachertypeController::class, 'update']);
    Route::delete('/admin/institucion/tiposdocente/destroy/{id}', [TeachertypeController::class, 'destroy']);
    // TIPO DE DOCENTE - FIN


    // TIPO DE IDENTIFICACION - INICIO
    Route::get('/admin/institucion/tiposidenti', [IdentificationtypeController::class, 'index'])->name('admin.institucion.tiposidenti');
    Route::get('/admin/institucion/tiposidenti/list', [IdentificationtypeController::class, 'list']);
    Route::post('/admin/institucion/tiposidenti/store', [IdentificationtypeController::class, 'store']);
    Route::put('/admin/institucion/tiposidenti/update/{id}', [IdentificationtypeController::class, 'update']);
    Route::delete('/admin/institucion/tiposidenti/destroy/{id}', [IdentificationtypeController::class, 'destroy']);
    // TIPO DE IDENTIFICACION - FIN


    // TIPO DE CONTRATO DOCENTE - INICIO
    Route::get('/admin/institucion/tiposcontratodocente', [TeachercontracttypeController::class, 'index'])->name('admin.institucion.tiposcontratodocente');
    Route::get('/admin/institucion/tiposcontratodocente/list', [TeachercontracttypeController::class, 'list']);
    Route::post('/admin/institucion/tiposcontratodocente/store', [TeachercontracttypeController::class, 'store']);
    Route::put('/admin/institucion/tiposcontratodocente/update/{id}', [TeachercontracttypeController::class, 'update']);
    Route::delete('/admin/institucion/tiposcontratodocente/destroy/{id}', [TeachercontracttypeController::class, 'destroy']);
    // TIPO DE CONTRATO DOCENTE - FIN
});
/* --------------------------
    FIN - INSTITUCION
    --------------------------*/



/* --------------------------
    INICIO - PLANES DE ESTUDIO
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:1,4,5,7', 'page_accessroute:3']], function () {
    // GESTIONAR PLANES - INICIO
    Route::get('/admin/planes_estudio/importar', [PlanController::class, 'importar'])->name('admin.planes_estudio.importar');
    Route::get('/admin/planes_estudio/planes', [PlanController::class, 'index'])->name('admin.planes_estudio.planes');
    Route::delete('/admin/planes_estudio/planes/destroy/{id}', [PlanController::class, 'destroy']);
    Route::get('/admin/planes_estudio/planes/list', [PlanController::class, 'list'])->name('admin.planes_estudio.planes.list');
    Route::post('/admin/planes_estudio/planes/store', [PlanController::class, 'store'])->name('admin.planes_estudio.planes.store');
    Route::post('/admin/planes_estudio/planes/update', [PlanController::class, 'update']);
    Route::get('/verDocumentoPlan/{idplan}', [PlanController::class, 'verDocumentoPlan']);
    Route::post('/admin/planes_estudio/planes/download', [DownloadExcelController::class, 'downloadExcelFile'])->name('admin.planes_estudio.planes.download');
    Route::post('/admin/planes_estudio/planes/upload/{idplan}/{option}', [UploadExcelController::class, 'uploadExcelFile'])->name('admin.planes_estudio.planes.upload');
    Route::put('/admin/planes_estudio/planes/update/course/{id}', [UploadExcelController::class, 'uploadcourse'])->name('admin.planes_estudio.planes.update.course');
    Route::post('/admin/planes_estudio/planes/ajax_all_by_idPLan_curses', [PlanController::class, 'ajax_all_by_idPLan_curses'])->name('admin.planes_estudio.planes.ajax_all_by_idPLan_curses');
    Route::post('/admin/planes_estudio/planes/list_by_idplan', [PlanController::class, 'list_by_idplan']);
    // GESTIONAR PLANES - FIN
});
/* --------------------------
    FIN - PLANES DE ESTUDIO
    --------------------------*/




/* --------------------------
    INICIO - PORTAFOLIO DOCENTES
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:1,4,5,7', 'page_accessroute:5']], function () {
    // DOCENTES - INICIO
    Route::get('/admin/portafolio/docentes', [TeacherController::class, 'index'])->name('admin.docentes.gestionar');
    Route::post('/admin/portafolio/docentes/list', [TeacherController::class, 'list']);
    Route::post('/admin/portafolio/docentes/store', [TeacherController::class, 'store']);
    Route::put('/admin/portafolio/docentes/update/{id}', [TeacherController::class, 'update']);
    Route::put('/admin/portafolio/docentes/update_password/{id}', [TeacherController::class, 'update_password']);
    Route::delete('/admin/portafolio/docentes/destroy/{id}', [TeacherController::class, 'destroy']);
    Route::post('/admin/incripciones/teachers/plantilla/download', [TeacherController::class, 'downloadExcelFile'])->name('inscripcion.teachers.plantilla.download');
    Route::post('/admin/inscripciones/teachers/storePlantilla', [TeacherController::class, 'store_plantilla']);
});
/* --------------------------
    FIN - PORTAFOLIO DOCENTES
    --------------------------*/


/* --------------------------
    INICIO - INSCRIPCIÓN ESTUDIANTES
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:1,4,5,7', 'page_accessroute:4']], function () {
    // GESTIONAR ESTUDIANTES - INICIO
    Route::get('/admin/incripciones/students', [InscripcionesstudentsController::class, 'index'])->name('admin.incripcion.students');
    Route::get('/admin/programs/list/', [InscripcionesstudentsController::class, 'list'])->name('admin.programs.list');
    Route::get('/admin/inscripciones/programs/list_plans/{idprogram}', [InscripcionesstudentsController::class, 'listplans']);
    Route::get('/admin/inscripciones/students/list', [InscripcionesstudentsController::class, 'liststudents'])->name('admin.inscripciones.students.list');
    Route::post('/admin/incripciones/students/plantilla/download', [DownloadExcelplantillaStudentsController::class, 'downloadExcelFile'])->name('inscripcion.students.plantilla.download');
    Route::post('/admin/inscripciones/students/storePlantilla', [InscripcionesstudentsController::class, 'store_plantilla']);

    Route::post('/admin/inscripciones/students/store', [StudentController::class, 'store']);
    Route::put('/admin/inscripciones/students/update/{id}', [StudentController::class, 'update']);
    Route::put('/admin/inscripciones/students/update_password/{id}', [StudentController::class, 'update_password']);
    Route::put('/admin/inscripciones/students/update_plan/{id}', [StudentController::class, 'update_plan']);
    Route::delete('/admin/inscripciones/students/destroy/{id}', [StudentController::class, 'destroy']);
    // GESTIONAR ESTUDIANTES - FIN
});
/* --------------------------
    FIN - INSCRIPCIÓN ESTUDIANTES
    --------------------------*/



/* --------------------------
    INICIO - BOLSA LABORAL
    --------------------------*/
Route::group(['middleware' => ['checksession', 'checkestado',  'checktypeuser:1,4,5,7', 'page_accessroute:13']], function () {

    // EMPRESAS - INICIO
    Route::get('/admin/bolsa_laboral/empresas', [JpcompanyController::class, 'index'])->name('admin.bolsa_laboral.empresas');
    Route::post('/admin/bolsa_laboral/empresas/list', [JpcompanyController::class, 'list']);
    Route::post('/admin/bolsa_laboral/empresas/listSolicitudes', [JpcompanyController::class, 'listSolicitudes']);
    Route::post('/admin/bolsa_laboral/empresas/store', [JpcompanyController::class, 'storeSolicitud']);
    Route::put('/admin/bolsa_laboral/empresas/update/{id}', [JpcompanyController::class, 'update']);
    Route::put('/admin/bolsa_laboral/empresas/updateEstado/{id}/{estado}', [JpcompanyController::class, 'updateEstado']);
    Route::put('/admin/bolsa_laboral/empresas/update_password/{id}', [JpcompanyController::class, 'update_password']);
    Route::delete('/admin/bolsa_laboral/empresas/destroy/{id}', [JpcompanyController::class, 'destroy']);
    // EMPRESAS - INICIO


    // CATEGORIAS Y ETIQUETAS - INICIO
    Route::get('/admin/bolsa_laboral/categorias_etiquetas', [CategoryTagController::class, 'index'])->name('admin.bolsa_laboral.categorias_etiquetas');
    // CATEGORIAS Y ETIQUETAS - FIN

    // CATEGORIAS - INICIO
    Route::post('/admin/bolsa_laboral/categorias/list', [JpcategoryController::class, 'list']);
    Route::post('/admin/bolsa_laboral/categorias/store', [JpcategoryController::class, 'store']);
    Route::put('/admin/bolsa_laboral/categorias/update/{id}', [JpcategoryController::class, 'update']);
    Route::delete('/admin/bolsa_laboral/categorias/destroy/{id}', [JpcategoryController::class, 'destroy']);
    // CATEGORIAS - INICIO

    // ETIQUETAS - INICIO
    Route::post('/admin/bolsa_laboral/etiquetas/list', [JptagController::class, 'list']);
    Route::post('/admin/bolsa_laboral/etiquetas/store', [JptagController::class, 'store']);
    Route::put('/admin/bolsa_laboral/etiquetas/update/{id}', [JptagController::class, 'update']);
    Route::delete('/admin/bolsa_laboral/etiquetas/destroy/{id}', [JptagController::class, 'destroy']);
    // ETIQUETAS - INICIO


    // OFERTAS LABORALES - INICIO
    Route::get('/admin/bolsa_laboral/ofertas_laborales', [JpjobController::class, 'index'])->name('admin.bolsa_laboral.ofertas_laborales');
    Route::post('/admin/bolsa_laboral/ofertas_laborales/list', [JpjobController::class, 'list']);
    Route::post('/admin/bolsa_laboral/ofertas_laborales/store', [JpjobController::class, 'store']);
    Route::post('/admin/bolsa_laboral/ofertas_laborales/update/{id}', [JpjobController::class, 'update']);
    Route::delete('/admin/bolsa_laboral/ofertas_laborales/destroy/{id}', [JpjobController::class, 'destroy']);
    // OFERTAS LABORALES - FIN

    // POSTULACIONES - INICIO
    Route::get('/admin/bolsa_laboral/postulaciones', [JpjobapplicationController::class, 'index'])->name('admin.bolsa_laboral.postulaciones');
    Route::post('/admin/bolsa_laboral/postulaciones/list', [JpjobapplicationController::class, 'list']);
    Route::put('/admin/bolsa_laboral/postulaciones/aprobar/{id}', [JpjobapplicationController::class, 'aprobar']);
    Route::put('/admin/bolsa_laboral/postulaciones/rechazar/{id}', [JpjobapplicationController::class, 'rechazar']);
    Route::delete('/admin/bolsa_laboral/postulaciones/destroy/{id}', [JpjobapplicationController::class, 'destroy']);
    Route::get('/verCurriculumVitae/{idjobapplication}', [FileController::class, 'verCurriculumVitae']);
    // POSTULACIONES - FIN

});
/* --------------------------
    FIN - BOLSA LABORAL
    --------------------------*/

/* ---------------------------------------------------------------------------------------------------------------------------------- */
/* RUTAS PARA ADMINISTRADORES */
/* ---------------------------------------------------------------------------------------------------------------------------------- */
